/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import tech.picnic.errorprone.bugpatterns.util.AnnotationAttributeMatcher;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Prefer the conciseness of `@{Get,Put,Post,Delete,Patch}Mapping` over `@RequestMapping`", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class SpringMvcAnnotation
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String ANN_PACKAGE_PREFIX = "org.springframework.web.bind.annotation.";
    private static final AnnotationAttributeMatcher ARGUMENT_SELECTOR = AnnotationAttributeMatcher.create(Optional.of(ImmutableList.of((Object)"org.springframework.web.bind.annotation.RequestMapping#method")), (Iterable<String>)ImmutableList.of());
    private static final ImmutableMap<String, String> REPLACEMENTS = ImmutableMap.builder().put((Object)"DELETE", (Object)"DeleteMapping").put((Object)"GET", (Object)"GetMapping").put((Object)"PATCH", (Object)"PatchMapping").put((Object)"POST", (Object)"PostMapping").put((Object)"PUT", (Object)"PutMapping").build();

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        return ARGUMENT_SELECTOR.extractMatchingArguments(tree).findFirst().flatMap(arg -> SpringMvcAnnotation.trySimplification(tree, arg, state)).map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    private static Optional<Fix> trySimplification(AnnotationTree tree, ExpressionTree arg, VisitorState state) {
        return SpringMvcAnnotation.extractUniqueMethod(arg, state).map(arg_0 -> REPLACEMENTS.get(arg_0)).map(newAnnotation -> SpringMvcAnnotation.replaceAnnotation(tree, arg, newAnnotation, state));
    }

    private static Optional<String> extractUniqueMethod(ExpressionTree arg, VisitorState state) {
        Verify.verify((arg.getKind() == Tree.Kind.ASSIGNMENT ? 1 : 0) != 0, (String)"Annotation attribute is not an assignment: %s", (Object)((Object)arg.getKind()));
        ExpressionTree expr = ((AssignmentTree)arg).getExpression();
        if (expr.getKind() != Tree.Kind.NEW_ARRAY) {
            return Optional.of(SpringMvcAnnotation.extractMethod(expr, state));
        }
        NewArrayTree newArray = (NewArrayTree)expr;
        return Optional.of(newArray.getInitializers()).filter(args -> args.size() == 1).map(args -> SpringMvcAnnotation.extractMethod((ExpressionTree)args.get(0), state));
    }

    private static String extractMethod(ExpressionTree expr, VisitorState state) {
        switch (expr.getKind()) {
            case IDENTIFIER: {
                return SourceCode.treeToString(expr, state);
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)expr).getIdentifier().toString();
            }
        }
        throw new VerifyException("Unexpected type of expression: " + expr.getKind());
    }

    private static Fix replaceAnnotation(AnnotationTree tree, ExpressionTree argToRemove, String newAnnotation, VisitorState state) {
        String newArguments = tree.getArguments().stream().filter(Predicate.not(argToRemove::equals)).map(arg -> SourceCode.treeToString(arg, state)).collect(Collectors.joining(", "));
        return SuggestedFix.builder().addImport(ANN_PACKAGE_PREFIX + newAnnotation).replace((Tree)tree, String.format("@%s(%s)", newAnnotation, newArguments)).build();
    }
}

