/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;

@BugPattern(summary="`@RequestParam` does not support `ImmutableCollection` and `ImmutableMap` subtypes", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class RequestParamType
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<VariableTree> HAS_UNSUPPORTED_REQUEST_PARAM = Matchers.allOf((Matcher[])new Matcher[]{Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isType((String)"org.springframework.web.bind.annotation.RequestParam")), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf(ImmutableCollection.class), Matchers.isSubtypeOf(ImmutableMap.class)})});

    public Description matchVariable(VariableTree tree, VisitorState state) {
        return HAS_UNSUPPORTED_REQUEST_PARAM.matches((Tree)tree, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

