/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.SortedSet;
import javax.lang.model.element.Modifier;

@BugPattern(summary="`SortedSet` properties of a `@Value.Immutable` or `@Value.Modifiable` type must be annotated with `@Value.NaturalOrder` or `@Value.ReverseOrder`", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class ImmutablesSortedSetComparator
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<MethodTree> METHOD_LACKS_ANNOTATION = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodReturns((Matcher)Matchers.isSubtypeOf(SortedSet.class)), Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.ABSTRACT), Matchers.enclosingClass((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"org.immutables.value.Value.Immutable"), Matchers.hasAnnotation((String)"org.immutables.value.Value.Modifiable")}))}), Matchers.hasAnnotation((String)"org.immutables.value.Value.Default")}), Matchers.not((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"org.immutables.value.Value.NaturalOrder"), Matchers.hasAnnotation((String)"org.immutables.value.Value.ReverseOrder")}))});

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!METHOD_LACKS_ANNOTATION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String valueTypeIdentifier = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)builder, (String)"org.immutables.value.Value");
        return this.describeMatch(tree, (Fix)builder.prefixWith((Tree)tree, String.format("@%s.NaturalOrder ", valueTypeIdentifier)).build());
    }
}

