/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractOptionalAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;

final class AssertJOptionalRules {
    private AssertJOptionalRules() {
    }

    static final class AssertThatOptionalHasValueMatching<T> {
        AssertThatOptionalHasValueMatching() {
        }

        AbstractOptionalAssert<?, T> before(Optional<T> optional, Predicate<? super T> predicate) {
            return Assertions.assertThat(optional.filter(predicate)).isPresent();
        }

        AbstractObjectAssert<?, T> after(Optional<T> optional, Predicate<? super T> predicate) {
            return (AbstractObjectAssert)Assertions.assertThat(optional).get().matches(predicate);
        }
    }

    static final class AbstractOptionalAssertContainsSame<T> {
        AbstractOptionalAssertContainsSame() {
        }

        AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert, T value) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{optionalAssert.get().isSameAs(value), optionalAssert.isPresent().isSameAs(value)});
        }

        AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert, T value) {
            return optionalAssert.containsSame(value);
        }
    }

    static final class AbstractOptionalAssertHasValue<T> {
        AbstractOptionalAssertHasValue() {
        }

        AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert, T value) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractAssert[]{optionalAssert.get().isEqualTo(value), optionalAssert.isEqualTo(Optional.of(value)), optionalAssert.contains(value), optionalAssert.isPresent().hasValue(value)});
        }

        AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert, T value) {
            return optionalAssert.hasValue(value);
        }
    }

    static final class AssertThatOptionalIsEmpty<T> {
        AssertThatOptionalIsEmpty() {
        }

        AbstractAssert<?, ?> before(Optional<T> optional) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((boolean)optional.isEmpty()).isTrue(), Assertions.assertThat((boolean)optional.isPresent()).isFalse()});
        }

        OptionalAssert<T> after(Optional<T> optional) {
            return (OptionalAssert)Assertions.assertThat(optional).isEmpty();
        }
    }

    static final class AbstractOptionalAssertIsEmpty<T> {
        AbstractOptionalAssertIsEmpty() {
        }

        AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractOptionalAssert[]{optionalAssert.isNotPresent(), (AbstractOptionalAssert)optionalAssert.isEqualTo(Optional.empty())});
        }

        AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert) {
            return optionalAssert.isEmpty();
        }
    }

    static final class AssertThatOptionalIsPresent<T> {
        AssertThatOptionalIsPresent() {
        }

        AbstractAssert<?, ?> before(Optional<T> optional) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractBooleanAssert[]{Assertions.assertThat((boolean)optional.isPresent()).isTrue(), Assertions.assertThat((boolean)optional.isEmpty()).isFalse()});
        }

        OptionalAssert<T> after(Optional<T> optional) {
            return (OptionalAssert)Assertions.assertThat(optional).isPresent();
        }
    }

    static final class AbstractOptionalAssertIsPresent<T> {
        AbstractOptionalAssertIsPresent() {
        }

        AbstractAssert<?, ?> before(AbstractOptionalAssert<?, T> optionalAssert) {
            return (AbstractAssert)Refaster.anyOf((Object[])new AbstractOptionalAssert[]{optionalAssert.isNotEmpty(), (AbstractOptionalAssert)optionalAssert.isNotEqualTo(Optional.empty())});
        }

        AbstractOptionalAssert<?, T> after(AbstractOptionalAssert<?, T> optionalAssert) {
            return optionalAssert.isPresent();
        }
    }

    static final class AssertThatOptional<T> {
        AssertThatOptional() {
        }

        ObjectAssert<T> before(Optional<T> optional) {
            return Assertions.assertThat(optional.orElseThrow());
        }

        AbstractObjectAssert<?, T> after(Optional<T> optional) {
            return Assertions.assertThat(optional).get();
        }
    }
}

