/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.base.CaseFormat;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.Modifier;
import tech.picnic.errorprone.utils.MoreASTHelpers;

@BugPattern(summary="SLF4J logger declarations should follow established best-practices", link="https://error-prone.picnic.tech/bugpatterns/Slf4jLoggerDeclaration", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
@AutoService(value={BugChecker.class})
public final class Slf4jLoggerDeclaration
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> IS_GET_LOGGER = Matchers.staticMethod().onDescendantOf("org.slf4j.LoggerFactory").named("getLogger");
    private static final String CANONICAL_STATIC_LOGGER_NAME_FLAG = "Slf4jLogDeclaration:CanonicalStaticLoggerName";
    private static final String DEFAULT_CANONICAL_LOGGER_NAME = "LOG";
    private static final Matcher<ExpressionTree> IS_STATIC_ENCLOSING_CLASS_REFERENCE = Matchers.classLiteral(Slf4jLoggerDeclaration::isEnclosingClassReference);
    private static final Matcher<ExpressionTree> IS_DYNAMIC_ENCLOSING_CLASS_REFERENCE = Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("getClass").withNoParameters(), Slf4jLoggerDeclaration::getClassReceiverIsEnclosingClassInstance}));
    private static final ImmutableSet<Modifier> INSTANCE_DECLARATION_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PRIVATE, (Enum[])new Modifier[]{Modifier.FINAL});
    private static final ImmutableSet<Modifier> STATIC_DECLARATION_MODIFIERS = Sets.immutableEnumSet((Enum)Modifier.PRIVATE, (Enum[])new Modifier[]{Modifier.STATIC, Modifier.FINAL});
    private final String canonicalStaticFieldName;
    private final String canonicalInstanceFieldName;

    public Slf4jLoggerDeclaration() {
        this(ErrorProneFlags.empty());
    }

    @Inject
    Slf4jLoggerDeclaration(ErrorProneFlags flags) {
        this.canonicalStaticFieldName = flags.get(CANONICAL_STATIC_LOGGER_NAME_FLAG).orElse(DEFAULT_CANONICAL_LOGGER_NAME);
        this.canonicalInstanceFieldName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.canonicalStaticFieldName);
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        ExpressionTree initializer = tree.getInitializer();
        if (!IS_GET_LOGGER.matches((Tree)initializer, state)) {
            return Description.NO_MATCH;
        }
        ClassTree clazz = Slf4jLoggerDeclaration.getEnclosingClass(state);
        ExpressionTree factoryArg = (ExpressionTree)Iterables.getOnlyElement(((MethodInvocationTree)initializer).getArguments());
        SuggestedFix.Builder fix = SuggestedFix.builder();
        if (clazz.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && IS_DYNAMIC_ENCLOSING_CLASS_REFERENCE.matches((Tree)factoryArg, state)) {
            Slf4jLoggerDeclaration.suggestModifiers(tree, INSTANCE_DECLARATION_MODIFIERS, fix, state);
            Slf4jLoggerDeclaration.suggestRename(tree, this.canonicalInstanceFieldName, fix, state);
        } else {
            Slf4jLoggerDeclaration.suggestModifiers(tree, clazz.getKind() == Tree.Kind.INTERFACE ? ImmutableSet.of() : STATIC_DECLARATION_MODIFIERS, fix, state);
            Slf4jLoggerDeclaration.suggestRename(tree, this.canonicalStaticFieldName, fix, state);
            if (!MoreASTHelpers.isStringTyped((Tree)factoryArg, (VisitorState)state) && !IS_STATIC_ENCLOSING_CLASS_REFERENCE.matches((Tree)factoryArg, state)) {
                fix.merge(SuggestedFix.replace((Tree)factoryArg, (String)(String.valueOf(clazz.getSimpleName()) + ".class")));
            }
        }
        return fix.isEmpty() ? Description.NO_MATCH : this.describeMatch(tree, (Fix)fix.build());
    }

    private static void suggestModifiers(VariableTree tree, ImmutableSet<Modifier> modifiers, SuggestedFix.Builder fixBuilder, VisitorState state) {
        ModifiersTree modifiersTree = Objects.requireNonNull(ASTHelpers.getModifiers((Tree)tree), "`VariableTree` must have modifiers");
        SuggestedFixes.addModifiers((Tree)tree, (ModifiersTree)modifiersTree, (VisitorState)state, modifiers).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
        SuggestedFixes.removeModifiers((ModifiersTree)modifiersTree, (VisitorState)state, (Set)Sets.difference(EnumSet.allOf(Modifier.class), modifiers)).ifPresent(arg_0 -> ((SuggestedFix.Builder)fixBuilder).merge(arg_0));
    }

    private static void suggestRename(VariableTree variableTree, String name, SuggestedFix.Builder fixBuilder, VisitorState state) {
        if (!variableTree.getName().contentEquals(name)) {
            fixBuilder.merge(SuggestedFixes.renameVariable((VariableTree)variableTree, (String)name, (VisitorState)state));
        }
    }

    private static boolean isEnclosingClassReference(ExpressionTree tree, VisitorState state) {
        return ASTHelpers.getSymbol((ClassTree)Slf4jLoggerDeclaration.getEnclosingClass(state)).equals(ASTHelpers.getSymbol((Tree)tree));
    }

    private static boolean getClassReceiverIsEnclosingClassInstance(MethodInvocationTree getClassInvocationTree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)getClassInvocationTree);
        if (receiver == null) {
            return true;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)receiver);
        return symbol != null && symbol.asType().tsym.equals(ASTHelpers.getSymbol((ClassTree)Slf4jLoggerDeclaration.getEnclosingClass(state)));
    }

    private static ClassTree getEnclosingClass(VisitorState state) {
        ClassTree clazz = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        Verify.verify((clazz != null ? 1 : 0) != 0, (String)"Variable not defined inside class", (Object[])new Object[0]);
        return clazz;
    }
}

