/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.refaster.Refaster;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

final class FileRules {
    private FileRules() {
    }

    static final class FilesCreateTempFileToFile {
        FilesCreateTempFileToFile() {
        }

        File before(String prefix, String suffix) throws IOException {
            return (File)Refaster.anyOf((Object[])new File[]{File.createTempFile(prefix, suffix), File.createTempFile(prefix, suffix, null)});
        }

        File after(String prefix, String suffix) throws IOException {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        }
    }

    static final class FilesReadString {
        FilesReadString() {
        }

        String before(Path path) throws IOException {
            return Files.readString(path, StandardCharsets.UTF_8);
        }

        String after(Path path) throws IOException {
            return Files.readString(path);
        }
    }

    static final class FilesReadStringWithCharset {
        FilesReadStringWithCharset() {
        }

        String before(Path path, Charset charset) throws IOException {
            return new String(Files.readAllBytes(path), charset);
        }

        String after(Path path, Charset charset) throws IOException {
            return Files.readString(path, charset);
        }
    }
}

