/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ComparatorRules {
    private ComparatorRules() {
    }

    static final class IsLessThanOrEqualTo<E extends Enum<E>> {
        IsLessThanOrEqualTo() {
        }

        boolean before(E value1, E value2) {
            return ((Enum)value1).ordinal() <= ((Enum)value2).ordinal();
        }

        boolean after(E value1, E value2) {
            return ((Enum)value1).compareTo(value2) <= 0;
        }
    }

    static final class IsLessThan<E extends Enum<E>> {
        IsLessThan() {
        }

        boolean before(E value1, E value2) {
            return ((Enum)value1).ordinal() < ((Enum)value2).ordinal();
        }

        boolean after(E value1, E value2) {
            return ((Enum)value1).compareTo(value2) < 0;
        }
    }

    static final class MaxByNaturalOrder<T extends Comparable<? super T>> {
        MaxByNaturalOrder() {
        }

        Collector<T, ?, Optional<T>> before() {
            return Collectors.minBy(Comparator.reverseOrder());
        }

        Collector<T, ?, Optional<T>> after() {
            return Collectors.maxBy(Comparator.naturalOrder());
        }
    }

    static final class MinByNaturalOrder<T extends Comparable<? super T>> {
        MinByNaturalOrder() {
        }

        Collector<T, ?, Optional<T>> before() {
            return Collectors.maxBy(Comparator.reverseOrder());
        }

        Collector<T, ?, Optional<T>> after() {
            return Collectors.minBy(Comparator.naturalOrder());
        }
    }

    static final class ComparatorsMax<T extends Comparable<? super T>> {
        ComparatorsMax() {
        }

        BinaryOperator<T> before() {
            return BinaryOperator.maxBy(Comparator.naturalOrder());
        }

        BinaryOperator<T> after() {
            return Comparators::max;
        }
    }

    static final class ComparatorsMin<T extends Comparable<? super T>> {
        ComparatorsMin() {
        }

        BinaryOperator<T> before() {
            return BinaryOperator.minBy(Comparator.naturalOrder());
        }

        BinaryOperator<T> after() {
            return Comparators::min;
        }
    }

    static final class MaxOfPairCustomOrder<T> {
        MaxOfPairCustomOrder() {
        }

        T before(T value1, T value2, Comparator<? super T> cmp) {
            return (T)Refaster.anyOf((Object[])new Object[]{cmp.compare(value1, value2) >= 0 ? value1 : value2, cmp.compare(value1, value2) < 0 ? value2 : value1, cmp.compare(value2, value1) > 0 ? value2 : value1, cmp.compare(value2, value1) <= 0 ? value1 : value2, Collections.max((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)}), cmp)});
        }

        T after(T value1, T value2, Comparator<? super T> cmp) {
            return (T)Comparators.max(value1, value2, cmp);
        }
    }

    static final class MaxOfPairNaturalOrder<T extends Comparable<? super T>> {
        MaxOfPairNaturalOrder() {
        }

        T before(T value1, T value2) {
            return (T)((Comparable)Refaster.anyOf((Object[])new Comparable[]{value1.compareTo(value2) >= 0 ? value1 : value2, value1.compareTo(value2) < 0 ? value2 : value1, value2.compareTo(value1) > 0 ? value2 : value1, value2.compareTo(value1) <= 0 ? value1 : value2, (Comparable)Comparators.max(value1, value2, Comparator.naturalOrder()), (Comparable)Comparators.min(value1, value2, Comparator.reverseOrder()), (Comparable)Collections.max((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)}))}));
        }

        T after(T value1, T value2) {
            return (T)Comparators.max(value1, value2);
        }
    }

    static final class MaxOfVarargs<T> {
        MaxOfVarargs() {
        }

        T before(T value, Comparator<T> cmp) {
            return (T)Stream.of(Refaster.asVarargs(value)).max(cmp).orElseThrow();
        }

        T after(T value, Comparator<T> cmp) {
            return (T)Collections.max(Arrays.asList(value), cmp);
        }
    }

    static final class MinOfPairCustomOrder<T> {
        MinOfPairCustomOrder() {
        }

        T before(T value1, T value2, Comparator<? super T> cmp) {
            return (T)Refaster.anyOf((Object[])new Object[]{cmp.compare(value1, value2) <= 0 ? value1 : value2, cmp.compare(value1, value2) > 0 ? value2 : value1, cmp.compare(value2, value1) < 0 ? value2 : value1, cmp.compare(value2, value1) >= 0 ? value1 : value2, Collections.min((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)}), cmp)});
        }

        T after(T value1, T value2, Comparator<? super T> cmp) {
            return (T)Comparators.min(value1, value2, cmp);
        }
    }

    static final class MinOfPairNaturalOrder<T extends Comparable<? super T>> {
        MinOfPairNaturalOrder() {
        }

        T before(T value1, T value2) {
            return (T)((Comparable)Refaster.anyOf((Object[])new Comparable[]{value1.compareTo(value2) <= 0 ? value1 : value2, value1.compareTo(value2) > 0 ? value2 : value1, value2.compareTo(value1) < 0 ? value2 : value1, value2.compareTo(value1) >= 0 ? value1 : value2, (Comparable)Comparators.min(value1, value2, Comparator.naturalOrder()), (Comparable)Comparators.max(value1, value2, Comparator.reverseOrder()), (Comparable)Collections.min((Collection)Refaster.anyOf((Object[])new Collection[]{Arrays.asList(value1, value2), ImmutableList.of(value1, value2), ImmutableSet.of(value1, value2)}))}));
        }

        T after(T value1, T value2) {
            return (T)Comparators.min(value1, value2);
        }
    }

    static final class MinOfVarargs<T> {
        MinOfVarargs() {
        }

        T before(T value, Comparator<T> cmp) {
            return (T)Stream.of(Refaster.asVarargs(value)).min(cmp).orElseThrow();
        }

        T after(T value, Comparator<T> cmp) {
            return (T)Collections.min(Arrays.asList(value), cmp);
        }
    }

    static final class CompareTo<T extends Comparable<? super T>> {
        CompareTo() {
        }

        int before(T value1, T value2) {
            return (Integer)Refaster.anyOf((Object[])new Integer[]{Comparator.naturalOrder().compare(value1, value2), Comparator.reverseOrder().compare(value2, value1)});
        }

        int after(T value1, T value2) {
            return value1.compareTo(value2);
        }
    }

    static final class ThenComparingNaturalOrder<T extends Comparable<? super T>> {
        ThenComparingNaturalOrder() {
        }

        Comparator<T> before(Comparator<T> cmp, Function<? super T, ? extends T> keyExtractor) {
            return cmp.thenComparing(keyExtractor);
        }

        Comparator<T> after(Comparator<T> cmp) {
            return cmp.thenComparing(Comparator.naturalOrder());
        }
    }

    static final class ThenComparingLong<T> {
        ThenComparingLong() {
        }

        Comparator<T> before(Comparator<T> cmp, ToLongFunction<? super T> function) {
            return cmp.thenComparing(Comparator.comparingLong(function));
        }

        Comparator<T> after(Comparator<T> cmp, ToLongFunction<? super T> function) {
            return cmp.thenComparingLong(function);
        }
    }

    static final class ThenComparingInt<T> {
        ThenComparingInt() {
        }

        Comparator<T> before(Comparator<T> cmp, ToIntFunction<? super T> function) {
            return cmp.thenComparing(Comparator.comparingInt(function));
        }

        Comparator<T> after(Comparator<T> cmp, ToIntFunction<? super T> function) {
            return cmp.thenComparingInt(function);
        }
    }

    static final class ThenComparingDouble<T> {
        ThenComparingDouble() {
        }

        Comparator<T> before(Comparator<T> cmp, ToDoubleFunction<? super T> function) {
            return cmp.thenComparing(Comparator.comparingDouble(function));
        }

        Comparator<T> after(Comparator<T> cmp, ToDoubleFunction<? super T> function) {
            return cmp.thenComparingDouble(function);
        }
    }

    static final class ThenComparingCustomReversed<S, T> {
        ThenComparingCustomReversed() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(Comparator.comparing(function, cmp2).reversed());
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(function, cmp2.reversed());
        }
    }

    static final class ThenComparingCustom<S, T> {
        ThenComparingCustom() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(Comparator.comparing(function, cmp2));
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function, Comparator<? super T> cmp2) {
            return cmp.thenComparing(function, cmp2);
        }
    }

    static final class ThenComparingReversed<S, T extends Comparable<? super T>> {
        ThenComparingReversed() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(Comparator.comparing(function).reversed());
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(function, Comparator.reverseOrder());
        }
    }

    static final class ThenComparing<S, T extends Comparable<? super T>> {
        ThenComparing() {
        }

        Comparator<S> before(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(Comparator.comparing(function));
        }

        Comparator<S> after(Comparator<S> cmp, Function<? super S, ? extends T> function) {
            return cmp.thenComparing(function);
        }
    }

    static abstract class ComparingEnum<E extends Enum<E>, T> {
        ComparingEnum() {
        }

        abstract E toEnumFunction(T var1);

        Comparator<T> before() {
            return Comparator.comparingInt(v -> ((Enum)this.toEnumFunction(v)).ordinal());
        }

        Comparator<T> after() {
            return Comparator.comparing(v -> this.toEnumFunction(v));
        }
    }

    static final class CustomComparator<T> {
        CustomComparator() {
        }

        Comparator<T> before(Comparator<T> cmp, Function<? super T, ? extends T> keyExtractor) {
            return Comparator.comparing(keyExtractor, cmp);
        }

        @CanIgnoreReturnValue
        Comparator<T> after(Comparator<T> cmp) {
            return cmp;
        }
    }

    static final class ReverseOrder<T extends Comparable<? super T>> {
        ReverseOrder() {
        }

        Comparator<T> before() {
            return (Comparator)Refaster.anyOf((Object[])new Comparator[]{Collections.reverseOrder(), Collections.reverseOrder(Comparator.naturalOrder()), Comparator.naturalOrder().reversed()});
        }

        Comparator<T> after() {
            return Comparator.reverseOrder();
        }
    }

    static final class NaturalOrder<T extends Comparable<? super T>> {
        NaturalOrder() {
        }

        Comparator<T> before(Function<? super T, ? extends T> keyExtractor) {
            return (Comparator)Refaster.anyOf((Object[])new Comparator[]{Comparable::compareTo, Comparator.comparing(keyExtractor), Collections.reverseOrder(Comparator.reverseOrder()), Comparator.reverseOrder().reversed()});
        }

        Comparator<T> after() {
            return Comparator.naturalOrder();
        }
    }
}

