/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class FileRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with files";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.FileRules`. [Source](https://error-prone.picnic.tech/refasterrules/FileRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new FilesReadStringWithCharsetRecipe(), new FilesReadStringRecipe(), new FilesCreateTempFileToFileRecipe()});
    }

    @NonNullApi
    public static class FilesReadStringWithCharsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Files#readString(Path, Charset)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilesReadStringWithCharset {\n    \n    @BeforeTemplate\n    String before(Path path, Charset charset) throws IOException {\n        return new String(Files.readAllBytes(path), charset);\n    }\n    \n    @AfterTemplate\n    String after(Path path, Charset charset) throws IOException {\n        return Files.readString(path, charset);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"new String(java.nio.file.Files.readAllBytes(#{path:any(java.nio.file.Path)}), #{charset:any(java.nio.charset.Charset)})").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, #{charset:any(java.nio.charset.Charset)})").build();

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesType("java.nio.charset.Charset", Boolean.valueOf(true)), new UsesMethod("java.lang.String <constructor>(..)"), new UsesMethod("java.nio.file.Files readAllBytes(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FilesReadStringRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Files#readString(Path)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilesReadString {\n    \n    @BeforeTemplate\n    String before(Path path) throws IOException {\n        return Files.readString(path, UTF_8);\n    }\n    \n    @AfterTemplate\n    String after(Path path) throws IOException {\n        return Files.readString(path);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)}, java.nio.charset.StandardCharsets.UTF_8)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.readString(#{path:any(java.nio.file.Path)})").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("java.nio.charset.StandardCharsets.UTF_8");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.nio.file.Files", Boolean.valueOf(true)), new UsesType("java.nio.file.Path", Boolean.valueOf(true)), new UsesMethod("java.nio.file.Files readString(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class FilesCreateTempFileToFileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Files#createTempFile(String, String, FileAttribute[])` over alternatives that create files with more liberal permissions";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FilesCreateTempFileToFile {\n    \n    @BeforeTemplate\n    @SuppressWarnings(value = \"java:S5443\")\n    File before(String prefix, String suffix) throws IOException {\n        return Refaster.anyOf(File.createTempFile(prefix, suffix), File.createTempFile(prefix, suffix, null));\n    }\n    \n    @AfterTemplate\n    @SuppressWarnings(value = \"java:S5443\")\n    File after(String prefix, String suffix) throws IOException {\n        return Files.createTempFile(prefix, suffix).toFile();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)})").build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"java.io.File.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}, null)").build();
                final JavaTemplate after = JavaTemplate.builder((String)"java.nio.file.Files.createTempFile(#{prefix:any(java.lang.String)}, #{suffix:any(java.lang.String)}).toFile()").build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.io.File", Boolean.valueOf(true)), new UsesMethod("java.io.File createTempFile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

