/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;
import reactor.core.publisher.Flux;

public class ReactorRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to Reactor expressions and statements";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.ReactorRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new FluxJustRecipe(), new StepVerifierLastStepVerifyCompleteRecipe(), new StepVerifierLastStepVerifyErrorRecipe(), new StepVerifierLastStepVerifyErrorMatchesRecipe(), new StepVerifierLastStepVerifyErrorSatisfiesRecipe(), new StepVerifierLastStepVerifyErrorMessageRecipe(), new StepVerifierLastStepVerifyTimeoutRecipe()});
    }

    @NonNullApi
    public static class FluxJustRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `Flux#just(Object)` over more contrived alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class FluxJust {\n    \n    @BeforeTemplate\n    Flux<Integer> before(int start) {\n        return Flux.range(start, 1);\n    }\n    \n    @AfterTemplate\n    Flux<Integer> after(int start) {\n        return Flux.just(start);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", start -> Flux.range((int)start, (int)1)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", start -> Flux.just((Object)start)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("reactor.core.publisher.Flux", Boolean.valueOf(true)), new UsesMethod("reactor.core.publisher.Flux range(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class StepVerifierLastStepVerifyCompleteRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `StepVerifier.LastStep#verifyComplete()` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StepVerifierLastStepVerifyComplete {\n    \n    @BeforeTemplate\n    Duration before(StepVerifier.LastStep step) {\n        return step.expectComplete().verify();\n    }\n    \n    @AfterTemplate\n    Duration after(StepVerifier.LastStep step) {\n        return step.verifyComplete();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", step -> step.expectComplete().verify()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", step -> step.verifyComplete()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)"), new UsesMethod("reactor.test.StepVerifier.LastStep expectComplete(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class StepVerifierLastStepVerifyErrorRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `StepVerifier.LastStep#verifyError()` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StepVerifierLastStepVerifyError {\n    \n    @BeforeTemplate\n    Duration before(StepVerifier.LastStep step) {\n        return step.expectError().verify();\n    }\n    \n    @AfterTemplate\n    Duration after(StepVerifier.LastStep step) {\n        return step.verifyError();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", step -> step.expectError().verify()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", step -> step.verifyError()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)"), new UsesMethod("reactor.test.StepVerifier.LastStep expectError(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class StepVerifierLastStepVerifyErrorMatchesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `StepVerifier.LastStep#verifyErrorMatches(Predicate)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StepVerifierLastStepVerifyErrorMatches {\n    \n    @BeforeTemplate\n    Duration before(StepVerifier.LastStep step, Predicate<Throwable> predicate) {\n        return step.expectErrorMatches(predicate).verify();\n    }\n    \n    @AfterTemplate\n    Duration after(StepVerifier.LastStep step, Predicate<Throwable> predicate) {\n        return step.verifyErrorMatches(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (step, predicate) -> step.expectErrorMatches(predicate).verify()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (step, predicate) -> step.verifyErrorMatches(predicate)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.util.function.Predicate", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)"), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorMatches(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class StepVerifierLastStepVerifyErrorSatisfiesRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `StepVerifier.LastStep#verifyErrorSatisfies(Consumer)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StepVerifierLastStepVerifyErrorSatisfies {\n    \n    @BeforeTemplate\n    Duration before(StepVerifier.LastStep step, Consumer<Throwable> consumer) {\n        return step.expectErrorSatisfies(consumer).verify();\n    }\n    \n    @AfterTemplate\n    Duration after(StepVerifier.LastStep step, Consumer<Throwable> consumer) {\n        return step.verifyErrorSatisfies(consumer);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (step, consumer) -> step.expectErrorSatisfies(consumer).verify()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (step, consumer) -> step.verifyErrorSatisfies(consumer)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesType("java.util.function.Consumer", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)"), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorSatisfies(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class StepVerifierLastStepVerifyErrorMessageRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `StepVerifier.LastStep#verifyErrorMessage(String)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StepVerifierLastStepVerifyErrorMessage {\n    \n    @BeforeTemplate\n    Duration before(StepVerifier.LastStep step, String message) {\n        return step.expectErrorMessage(message).verify();\n    }\n    \n    @AfterTemplate\n    Duration after(StepVerifier.LastStep step, String message) {\n        return step.verifyErrorMessage(message);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (step, message) -> step.expectErrorMessage(message).verify()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (step, message) -> step.verifyErrorMessage(message)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)"), new UsesMethod("reactor.test.StepVerifier.LastStep expectErrorMessage(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class StepVerifierLastStepVerifyTimeoutRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `StepVerifier.LastStep#verifyTimeout(Duration)` over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class StepVerifierLastStepVerifyTimeout {\n    \n    @BeforeTemplate\n    Duration before(StepVerifier.LastStep step, Duration duration) {\n        return step.expectTimeout(duration).verify();\n    }\n    \n    @AfterTemplate\n    Duration after(StepVerifier.LastStep step, Duration duration) {\n        return step.verifyTimeout(duration);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (step, duration) -> step.expectTimeout(duration).verify()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (step, duration) -> step.verifyTimeout(duration)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.time.Duration", Boolean.valueOf(true)), new UsesMethod("reactor.test.StepVerifier verify(..)"), new UsesMethod("reactor.test.StepVerifier.LastStep expectTimeout(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

