/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import java.time.Duration;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.core.CorePublisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.TupleUtils;
import reactor.math.MathFlux;
import reactor.test.StepVerifier;
import reactor.test.publisher.PublisherProbe;
import reactor.util.context.Context;
import reactor.util.function.Tuple2;

final class ReactorRules {
    private ReactorRules() {
    }

    static final class StepVerifierLastStepVerifyTimeout {
        StepVerifierLastStepVerifyTimeout() {
        }

        Duration before(StepVerifier.LastStep step, Duration duration) {
            return step.expectTimeout(duration).verify();
        }

        Duration after(StepVerifier.LastStep step, Duration duration) {
            return step.verifyTimeout(duration);
        }
    }

    static final class StepVerifierLastStepVerifyErrorMessage {
        StepVerifierLastStepVerifyErrorMessage() {
        }

        Duration before(StepVerifier.LastStep step, String message) {
            return step.expectErrorMessage(message).verify();
        }

        Duration after(StepVerifier.LastStep step, String message) {
            return step.verifyErrorMessage(message);
        }
    }

    static final class StepVerifierLastStepVerifyErrorSatisfies {
        StepVerifierLastStepVerifyErrorSatisfies() {
        }

        Duration before(StepVerifier.LastStep step, Consumer<Throwable> consumer) {
            return step.expectErrorSatisfies(consumer).verify();
        }

        Duration after(StepVerifier.LastStep step, Consumer<Throwable> consumer) {
            return step.verifyErrorSatisfies(consumer);
        }
    }

    static final class StepVerifierLastStepVerifyErrorMatches {
        StepVerifierLastStepVerifyErrorMatches() {
        }

        Duration before(StepVerifier.LastStep step, Predicate<Throwable> predicate) {
            return step.expectErrorMatches(predicate).verify();
        }

        Duration after(StepVerifier.LastStep step, Predicate<Throwable> predicate) {
            return step.verifyErrorMatches(predicate);
        }
    }

    static final class StepVerifierLastStepVerifyErrorClass<T extends Throwable> {
        StepVerifierLastStepVerifyErrorClass() {
        }

        Duration before(StepVerifier.LastStep step, Class<T> clazz) {
            Object[] objectArray = new Duration[3];
            objectArray[0] = step.expectError(clazz).verify();
            objectArray[1] = step.verifyErrorMatches(clazz::isInstance);
            objectArray[2] = step.verifyErrorSatisfies(t -> Assertions.assertThat((Throwable)t).isInstanceOf(clazz));
            return (Duration)Refaster.anyOf((Object[])objectArray);
        }

        Duration after(StepVerifier.LastStep step, Class<T> clazz) {
            return step.verifyError(clazz);
        }
    }

    static final class StepVerifierLastStepVerifyError {
        StepVerifierLastStepVerifyError() {
        }

        Duration before(StepVerifier.LastStep step) {
            return step.expectError().verify();
        }

        Duration after(StepVerifier.LastStep step) {
            return step.verifyError();
        }
    }

    static final class StepVerifierLastStepVerifyComplete {
        StepVerifierLastStepVerifyComplete() {
        }

        Duration before(StepVerifier.LastStep step) {
            return step.expectComplete().verify();
        }

        Duration after(StepVerifier.LastStep step) {
            return step.verifyComplete();
        }
    }

    static final class FluxAsStepVerifierExpectNext<T, L extends List<T>> {
        FluxAsStepVerifierExpectNext() {
        }

        StepVerifier.Step<L> before(Flux<T> flux, T object, Collector<? super T, ?, L> listCollector) {
            return ((StepVerifier.FirstStep)flux.collect(listCollector).as(StepVerifier::create)).assertNext(list -> Assertions.assertThat((List)list).containsExactly(new Object[]{object}));
        }

        StepVerifier.Step<T> after(Flux<T> flux, T object) {
            return ((StepVerifier.FirstStep)flux.as(StepVerifier::create)).expectNext(object);
        }
    }

    static final class StepVerifierStepExpectNext<T> {
        StepVerifierStepExpectNext() {
        }

        StepVerifier.Step<T> before(StepVerifier.Step<T> step, T object) {
            Object[] objectArray = new StepVerifier.Step[2];
            objectArray[0] = step.expectNextMatches(e -> e.equals(object));
            objectArray[1] = step.expectNextMatches(object::equals);
            return (StepVerifier.Step)Refaster.anyOf((Object[])objectArray);
        }

        StepVerifier.Step<T> after(StepVerifier.Step<T> step, T object) {
            return step.expectNext(object);
        }
    }

    static final class StepVerifierStepIdentity<T> {
        StepVerifierStepIdentity() {
        }

        StepVerifier.Step<T> before(StepVerifier.Step<T> step, Iterable<? extends T> iterable) {
            return (StepVerifier.Step)Refaster.anyOf((Object[])new StepVerifier.Step[]{step.expectNext(new Object[0]), step.expectNextCount(0L), step.expectNextSequence(iterable)});
        }

        @CanIgnoreReturnValue
        StepVerifier.Step<T> after(StepVerifier.Step<T> step) {
            return step;
        }
    }

    static final class StepVerifierFromFlux<T> {
        StepVerifierFromFlux() {
        }

        StepVerifier.FirstStep<? extends T> before(Flux<T> flux) {
            return StepVerifier.create(flux);
        }

        StepVerifier.FirstStep<? extends T> after(Flux<T> flux) {
            return (StepVerifier.FirstStep)flux.as(StepVerifier::create);
        }
    }

    static final class StepVerifierFromMono<T> {
        StepVerifierFromMono() {
        }

        StepVerifier.FirstStep<? extends T> before(Mono<T> mono) {
            return (StepVerifier.FirstStep)Refaster.anyOf((Object[])new StepVerifier.FirstStep[]{StepVerifier.create(mono), (StepVerifier.FirstStep)mono.flux().as(StepVerifier::create)});
        }

        StepVerifier.FirstStep<? extends T> after(Mono<T> mono) {
            return (StepVerifier.FirstStep)mono.as(StepVerifier::create);
        }
    }

    static final class PublisherProbeEmpty<T> {
        PublisherProbeEmpty() {
        }

        PublisherProbe<T> before() {
            return PublisherProbe.of((Publisher)((Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()})));
        }

        PublisherProbe<T> after() {
            return PublisherProbe.empty();
        }
    }

    static final class ContextEmpty {
        ContextEmpty() {
        }

        Context before(Map<?, ?> map) {
            return Context.of(map);
        }

        Context after() {
            return Context.empty();
        }
    }

    static final class MathFluxMax<T extends Comparable<? super T>> {
        MathFluxMax() {
        }

        Mono<T> before(Publisher<T> publisher) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{MathFlux.min(publisher, Comparator.reverseOrder()), MathFlux.max(publisher, Comparator.naturalOrder())});
        }

        Mono<T> after(Publisher<T> publisher) {
            return MathFlux.max(publisher);
        }
    }

    static final class MathFluxMin<T extends Comparable<? super T>> {
        MathFluxMin() {
        }

        Mono<T> before(Publisher<T> publisher) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{MathFlux.min(publisher, Comparator.naturalOrder()), MathFlux.max(publisher, Comparator.reverseOrder())});
        }

        Mono<T> after(Publisher<T> publisher) {
            return MathFlux.min(publisher);
        }
    }

    static final class FluxTransformMaxWithComparator<T extends Comparable<? super T>> {
        FluxTransformMaxWithComparator() {
        }

        Mono<T> before(Flux<T> flux, Comparator<? super T> cmp) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{flux.sort(cmp).last(), flux.collect(Collectors.maxBy(cmp)).flatMap(Mono::justOrEmpty)});
        }

        Mono<T> after(Flux<T> flux, Comparator<? super T> cmp) {
            return flux.transform(f -> MathFlux.max((Publisher)f, (Comparator)cmp)).singleOrEmpty();
        }
    }

    static final class FluxTransformMax<T extends Comparable<? super T>> {
        FluxTransformMax() {
        }

        Mono<T> before(Flux<T> flux) {
            return flux.sort().last();
        }

        Mono<T> after(Flux<T> flux) {
            return flux.transform(MathFlux::max).singleOrEmpty();
        }
    }

    static final class FluxTransformMinWithComparator<T extends Comparable<? super T>> {
        FluxTransformMinWithComparator() {
        }

        Mono<T> before(Flux<T> flux, Comparator<? super T> cmp) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{flux.sort(cmp).next(), flux.collect(Collectors.minBy(cmp)).flatMap(Mono::justOrEmpty)});
        }

        Mono<T> after(Flux<T> flux, Comparator<? super T> cmp) {
            return flux.transform(f -> MathFlux.min((Publisher)f, (Comparator)cmp)).singleOrEmpty();
        }
    }

    static final class FluxTransformMin<T extends Comparable<? super T>> {
        FluxTransformMin() {
        }

        Mono<T> before(Flux<T> flux) {
            return flux.sort().next();
        }

        Mono<T> after(Flux<T> flux) {
            return flux.transform(MathFlux::min).singleOrEmpty();
        }
    }

    static final class FluxSort<T extends Comparable<? super T>> {
        FluxSort() {
        }

        Flux<T> before(Flux<T> flux) {
            return flux.sort(Comparator.naturalOrder());
        }

        Flux<T> after(Flux<T> flux) {
            return flux.sort();
        }
    }

    static final class FluxCollectToImmutableSet<T> {
        FluxCollectToImmutableSet() {
        }

        Mono<ImmutableSet<T>> before(Flux<T> flux) {
            return flux.collect(ImmutableList.toImmutableList()).map(ImmutableSet::copyOf);
        }

        Mono<ImmutableSet<T>> after(Flux<T> flux) {
            return flux.collect(ImmutableSet.toImmutableSet());
        }
    }

    static final class FluxCollectToImmutableList<T> {
        FluxCollectToImmutableList() {
        }

        Mono<List<T>> before(Flux<T> flux) {
            return flux.collectList();
        }

        Mono<ImmutableList<T>> after(Flux<T> flux) {
            return flux.collect(ImmutableList.toImmutableList());
        }
    }

    static final class FluxTakeWhile<T> {
        FluxTakeWhile() {
        }

        Flux<T> before(Flux<T> flux, Predicate<? super T> predicate) {
            return flux.takeWhile(predicate).filter(predicate);
        }

        Flux<T> after(Flux<T> flux, Predicate<? super T> predicate) {
            return flux.takeWhile(predicate);
        }
    }

    static final class FluxFilterSortWithComparator<T> {
        FluxFilterSortWithComparator() {
        }

        Flux<T> before(Flux<T> flux, Predicate<? super T> predicate, Comparator<? super T> comparator) {
            return flux.sort(comparator).filter(predicate);
        }

        Flux<T> after(Flux<T> flux, Predicate<? super T> predicate, Comparator<? super T> comparator) {
            return flux.filter(predicate).sort(comparator);
        }
    }

    static final class FluxFilterSort<T> {
        FluxFilterSort() {
        }

        Flux<T> before(Flux<T> flux, Predicate<? super T> predicate) {
            return flux.sort().filter(predicate);
        }

        Flux<T> after(Flux<T> flux, Predicate<? super T> predicate) {
            return flux.filter(predicate).sort();
        }
    }

    static final class FluxOnErrorReturn<T> {
        FluxOnErrorReturn() {
        }

        Flux<T> before(Flux<T> flux, Class<? extends Throwable> clazz, T fallbackValue) {
            return flux.onErrorReturn(clazz::isInstance, fallbackValue);
        }

        Flux<T> after(Flux<T> flux, Class<? extends Throwable> clazz, T fallbackValue) {
            return flux.onErrorReturn(clazz, fallbackValue);
        }
    }

    static final class MonoOnErrorReturn<T> {
        MonoOnErrorReturn() {
        }

        Mono<T> before(Mono<T> mono, Class<? extends Throwable> clazz, T fallbackValue) {
            return mono.onErrorReturn(clazz::isInstance, fallbackValue);
        }

        Mono<T> after(Mono<T> mono, Class<? extends Throwable> clazz, T fallbackValue) {
            return mono.onErrorReturn(clazz, fallbackValue);
        }
    }

    static final class FluxOnErrorResume<T> {
        FluxOnErrorResume() {
        }

        Flux<T> before(Flux<T> flux, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Publisher<? extends T>> fallback) {
            return flux.onErrorResume(clazz::isInstance, fallback);
        }

        Flux<T> after(Flux<T> flux, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Publisher<? extends T>> fallback) {
            return flux.onErrorResume(clazz, fallback);
        }
    }

    static final class MonoOnErrorResume<T> {
        MonoOnErrorResume() {
        }

        Mono<T> before(Mono<T> mono, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Mono<? extends T>> fallback) {
            return mono.onErrorResume(clazz::isInstance, fallback);
        }

        Mono<T> after(Mono<T> mono, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Mono<? extends T>> fallback) {
            return mono.onErrorResume(clazz, fallback);
        }
    }

    static final class FluxOnErrorMap<T> {
        FluxOnErrorMap() {
        }

        Flux<T> before(Flux<T> flux, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Throwable> mapper) {
            return flux.onErrorMap(clazz::isInstance, mapper);
        }

        Flux<T> after(Flux<T> flux, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Throwable> mapper) {
            return flux.onErrorMap(clazz, mapper);
        }
    }

    static final class MonoOnErrorMap<T> {
        MonoOnErrorMap() {
        }

        Mono<T> before(Mono<T> mono, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Throwable> mapper) {
            return mono.onErrorMap(clazz::isInstance, mapper);
        }

        Mono<T> after(Mono<T> mono, Class<? extends Throwable> clazz, Function<? super Throwable, ? extends Throwable> mapper) {
            return mono.onErrorMap(clazz, mapper);
        }
    }

    static final class FluxOnErrorContinue<T> {
        FluxOnErrorContinue() {
        }

        Flux<T> before(Flux<T> flux, Class<? extends Throwable> clazz, BiConsumer<Throwable, Object> errorConsumer) {
            return flux.onErrorContinue(clazz::isInstance, errorConsumer);
        }

        Flux<T> after(Flux<T> flux, Class<? extends Throwable> clazz, BiConsumer<Throwable, Object> errorConsumer) {
            return flux.onErrorContinue(clazz, errorConsumer);
        }
    }

    static final class MonoOnErrorContinue<T> {
        MonoOnErrorContinue() {
        }

        Mono<T> before(Mono<T> mono, Class<? extends Throwable> clazz, BiConsumer<Throwable, Object> errorConsumer) {
            return mono.onErrorContinue(clazz::isInstance, errorConsumer);
        }

        Mono<T> after(Mono<T> mono, Class<? extends Throwable> clazz, BiConsumer<Throwable, Object> errorConsumer) {
            return mono.onErrorContinue(clazz, errorConsumer);
        }
    }

    static final class FluxOnErrorCompletePredicate<T> {
        FluxOnErrorCompletePredicate() {
        }

        Flux<T> before(Flux<T> flux, Predicate<? super Throwable> predicate) {
            return flux.onErrorResume(predicate, e -> (Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()}));
        }

        Flux<T> after(Flux<T> flux, Predicate<? super Throwable> predicate) {
            return flux.onErrorComplete(predicate);
        }
    }

    static final class MonoOnErrorCompletePredicate<T> {
        MonoOnErrorCompletePredicate() {
        }

        Mono<T> before(Mono<T> mono, Predicate<? super Throwable> predicate) {
            return mono.onErrorResume(predicate, e -> Mono.empty());
        }

        Mono<T> after(Mono<T> mono, Predicate<? super Throwable> predicate) {
            return mono.onErrorComplete(predicate);
        }
    }

    static final class FluxOnErrorCompleteClass<T> {
        FluxOnErrorCompleteClass() {
        }

        Flux<T> before(Flux<T> flux, Class<? extends Throwable> clazz) {
            Object[] objectArray = new Flux[2];
            objectArray[0] = flux.onErrorComplete(clazz::isInstance);
            objectArray[1] = flux.onErrorResume(clazz, e -> (Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()}));
            return (Flux)Refaster.anyOf((Object[])objectArray);
        }

        Flux<T> after(Flux<T> flux, Class<? extends Throwable> clazz) {
            return flux.onErrorComplete(clazz);
        }
    }

    static final class MonoOnErrorCompleteClass<T> {
        MonoOnErrorCompleteClass() {
        }

        Mono<T> before(Mono<T> mono, Class<? extends Throwable> clazz) {
            Object[] objectArray = new Mono[2];
            objectArray[0] = mono.onErrorComplete(clazz::isInstance);
            objectArray[1] = mono.onErrorResume(clazz, e -> Mono.empty());
            return (Mono)Refaster.anyOf((Object[])objectArray);
        }

        Mono<T> after(Mono<T> mono, Class<? extends Throwable> clazz) {
            return mono.onErrorComplete(clazz);
        }
    }

    static final class FluxOnErrorComplete<T> {
        FluxOnErrorComplete() {
        }

        Flux<T> before(Flux<T> flux) {
            return flux.onErrorResume(e -> (Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()}));
        }

        Flux<T> after(Flux<T> flux) {
            return flux.onErrorComplete();
        }
    }

    static final class MonoOnErrorComplete<T> {
        MonoOnErrorComplete() {
        }

        Mono<T> before(Mono<T> mono) {
            return mono.onErrorResume(e -> Mono.empty());
        }

        Mono<T> after(Mono<T> mono) {
            return mono.onErrorComplete();
        }
    }

    static final class FluxDoOnError<T> {
        FluxDoOnError() {
        }

        Flux<T> before(Flux<T> flux, Class<? extends Throwable> clazz, Consumer<? super Throwable> onError) {
            return flux.doOnError(clazz::isInstance, onError);
        }

        Flux<T> after(Flux<T> flux, Class<? extends Throwable> clazz, Consumer<? super Throwable> onError) {
            return flux.doOnError(clazz, onError);
        }
    }

    static final class MonoDoOnError<T> {
        MonoDoOnError() {
        }

        Mono<T> before(Mono<T> mono, Class<? extends Throwable> clazz, Consumer<? super Throwable> onError) {
            return mono.doOnError(clazz::isInstance, onError);
        }

        Mono<T> after(Mono<T> mono, Class<? extends Throwable> clazz, Consumer<? super Throwable> onError) {
            return mono.doOnError(clazz, onError);
        }
    }

    static final class FluxCountMapMathToIntExact<T> {
        FluxCountMapMathToIntExact() {
        }

        Mono<Integer> before(Flux<T> flux) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{flux.collect(ImmutableList.toImmutableList()).map((Function)Refaster.anyOf((Object[])new Function[]{Collection::size, List::size, AbstractCollection::size, List::size})), flux.collect(Collectors.toCollection(ArrayList::new)).map((Function)Refaster.anyOf((Object[])new Function[]{Collection::size, List::size}))});
        }

        Mono<Integer> after(Flux<T> flux) {
            return flux.count().map(Math::toIntExact);
        }
    }

    static final class ConcatMapIterableIdentityWithPrefetch<T> {
        ConcatMapIterableIdentityWithPrefetch() {
        }

        Flux<T> before(Flux<? extends Iterable<T>> flux, int prefetch) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.concatMap(list -> Flux.fromIterable((Iterable)list), prefetch), flux.concatMap(Flux::fromIterable, prefetch)});
        }

        Flux<T> after(Flux<? extends Iterable<T>> flux, int prefetch) {
            return flux.concatMapIterable(Function.identity(), prefetch);
        }
    }

    static final class ConcatMapIterableIdentity<T> {
        ConcatMapIterableIdentity() {
        }

        Flux<T> before(Flux<? extends Iterable<T>> flux) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.concatMap(list -> Flux.fromIterable((Iterable)list)), flux.concatMap(Flux::fromIterable)});
        }

        Flux<T> after(Flux<? extends Iterable<T>> flux) {
            return flux.concatMapIterable(Function.identity());
        }
    }

    static final class MonoFlatMapMany<S, T, P extends Publisher<? extends T>> {
        MonoFlatMapMany() {
        }

        Flux<T> before(Mono<S> mono, Function<? super S, P> function, Function<? super P, ? extends Publisher<? extends T>> identityOperation, int prefetch, boolean delayUntilEnd, int maxConcurrency) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{mono.map(function).flatMapMany(identityOperation), mono.flux().concatMap(function), mono.flux().concatMap(function, prefetch), mono.flux().concatMapDelayError(function), mono.flux().concatMapDelayError(function, prefetch), mono.flux().concatMapDelayError(function, delayUntilEnd, prefetch), mono.flux().flatMap(function, maxConcurrency), mono.flux().flatMap(function, maxConcurrency, prefetch), mono.flux().flatMapDelayError(function, maxConcurrency, prefetch), mono.flux().flatMapSequential(function, maxConcurrency), mono.flux().flatMapSequential(function, maxConcurrency, prefetch), mono.flux().flatMapSequentialDelayError(function, maxConcurrency, prefetch)});
        }

        Flux<T> before(Mono<S> mono, Function<? super S, Publisher<? extends T>> function) {
            return mono.flux().switchMap(function);
        }

        Flux<T> after(Mono<S> mono, Function<? super S, ? extends P> function) {
            return mono.flatMapMany(function);
        }
    }

    static final class MonoFlatMap<S, T, P extends Mono<? extends T>> {
        MonoFlatMap() {
        }

        Mono<T> before(Mono<S> mono, Function<? super S, ? extends P> function, Function<? super P, ? extends Mono<? extends T>> identityOperation) {
            return mono.map(function).flatMap(identityOperation);
        }

        Mono<T> after(Mono<S> mono, Function<? super S, ? extends P> function) {
            return mono.flatMap(function);
        }
    }

    static final class FluxOfType<T, S> {
        FluxOfType() {
        }

        Flux<S> before(Flux<T> flux, Class<S> clazz) {
            return flux.filter(clazz::isInstance).cast(clazz);
        }

        Flux<S> after(Flux<T> flux, Class<S> clazz) {
            return flux.ofType(clazz);
        }
    }

    static final class MonoOfType<T, S> {
        MonoOfType() {
        }

        Mono<S> before(Mono<T> mono, Class<S> clazz) {
            return mono.filter(clazz::isInstance).cast(clazz);
        }

        Mono<S> after(Mono<T> mono, Class<S> clazz) {
            return mono.ofType(clazz);
        }
    }

    static final class FluxCast<T, S> {
        FluxCast() {
        }

        Flux<S> before(Flux<T> flux) {
            return flux.map(Refaster.clazz()::cast);
        }

        Flux<S> after(Flux<T> flux) {
            return flux.cast(Refaster.clazz());
        }
    }

    static final class MonoCast<T, S> {
        MonoCast() {
        }

        Mono<S> before(Mono<T> mono) {
            return mono.map(Refaster.clazz()::cast);
        }

        Mono<S> after(Mono<T> mono) {
            return mono.cast(Refaster.clazz());
        }
    }

    static final class MonoSingleOptional<T> {
        MonoSingleOptional() {
        }

        Mono<Optional<T>> before(Mono<T> mono) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{mono.flux().collect(MoreCollectors.toOptional()), mono.map(Optional::of).defaultIfEmpty(Optional.empty()), mono.transform(Mono::singleOptional)});
        }

        Mono<Optional<T>> after(Mono<T> mono) {
            return mono.singleOptional();
        }
    }

    static final class FluxThenMono<T, S> {
        FluxThenMono() {
        }

        Mono<S> before(Flux<T> flux, Mono<S> mono) {
            return flux.ignoreElements().then(mono);
        }

        Mono<@Nullable Void> before2(Flux<T> flux, Mono<@Nullable Void> mono) {
            return flux.thenEmpty(mono);
        }

        Mono<S> after(Flux<T> flux, Mono<S> mono) {
            return flux.then(mono);
        }
    }

    static final class MonoThenMono<T, S> {
        MonoThenMono() {
        }

        Mono<S> before(Mono<T> mono1, Mono<S> mono2) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{mono1.ignoreElement().then(mono2), mono1.flux().then(mono2)});
        }

        Mono<@Nullable Void> before2(Mono<T> mono1, Mono<@Nullable Void> mono2) {
            return mono1.thenEmpty(mono2);
        }

        Mono<S> after(Mono<T> mono1, Mono<S> mono2) {
            return mono1.then(mono2);
        }
    }

    static final class FluxThenMany<T, S> {
        FluxThenMany() {
        }

        Flux<S> before(Flux<T> flux, Publisher<S> publisher) {
            return flux.ignoreElements().thenMany(publisher);
        }

        Flux<S> after(Flux<T> flux, Publisher<S> publisher) {
            return flux.thenMany(publisher);
        }
    }

    static final class MonoThenMonoFlux<T, S> {
        MonoThenMonoFlux() {
        }

        Flux<S> before(Mono<T> mono1, Mono<S> mono2) {
            return mono1.thenMany(mono2);
        }

        Flux<S> after(Mono<T> mono1, Mono<S> mono2) {
            return mono1.then(mono2).flux();
        }
    }

    static final class MonoThenMany<T, S> {
        MonoThenMany() {
        }

        Flux<S> before(Mono<T> mono, Publisher<S> publisher) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{mono.ignoreElement().thenMany(publisher), mono.flux().thenMany(publisher)});
        }

        Flux<S> after(Mono<T> mono, Publisher<S> publisher) {
            return mono.thenMany(publisher);
        }
    }

    static final class FluxThenEmpty<T> {
        FluxThenEmpty() {
        }

        Mono<@Nullable Void> before(Flux<T> flux, Publisher<@Nullable Void> publisher) {
            return flux.ignoreElements().thenEmpty(publisher);
        }

        Mono<@Nullable Void> after(Flux<T> flux, Publisher<@Nullable Void> publisher) {
            return flux.thenEmpty(publisher);
        }
    }

    static final class MonoThenEmpty<T> {
        MonoThenEmpty() {
        }

        Mono<@Nullable Void> before(Mono<T> mono, Publisher<@Nullable Void> publisher) {
            return mono.ignoreElement().thenEmpty(publisher);
        }

        Mono<@Nullable Void> after(Mono<T> mono, Publisher<@Nullable Void> publisher) {
            return mono.thenEmpty(publisher);
        }
    }

    static final class FluxThen<T> {
        FluxThen() {
        }

        Mono<@Nullable Void> before(Flux<T> flux) {
            return flux.ignoreElements().then();
        }

        Mono<@Nullable Void> before2(Flux<@Nullable Void> flux) {
            return flux.ignoreElements();
        }

        Mono<@Nullable Void> after(Flux<T> flux) {
            return flux.then();
        }
    }

    static final class MonoThen<T> {
        MonoThen() {
        }

        Mono<@Nullable Void> before(Mono<T> mono) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{mono.ignoreElement().then(), mono.flux().then()});
        }

        Mono<@Nullable Void> after(Mono<T> mono) {
            return mono.then();
        }
    }

    static final class MonoFlux<T> {
        MonoFlux() {
        }

        Flux<T> before(Mono<T> mono) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{mono.flatMapMany(Mono::just), mono.flatMapMany(Flux::just), Flux.concat((Publisher[])new Publisher[]{mono})});
        }

        Flux<T> after(Mono<T> mono) {
            return mono.flux();
        }
    }

    static abstract class FluxMapNotNull<T, S> {
        FluxMapNotNull() {
        }

        abstract S transformation(T var1);

        Publisher<S> before(Flux<T> flux, int prefetch, boolean delayUntilEnd, int maxConcurrency) {
            return (Publisher)Refaster.anyOf((Object[])new Flux[]{flux.concatMap(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))})), flux.concatMap(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), prefetch), flux.concatMapDelayError(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))})), flux.concatMapDelayError(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), prefetch), flux.concatMapDelayError(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), delayUntilEnd, prefetch), flux.flatMap(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), maxConcurrency), flux.flatMap(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), maxConcurrency, prefetch), flux.flatMapDelayError(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), maxConcurrency, prefetch), flux.flatMapSequential(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), maxConcurrency), flux.flatMapSequential(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), maxConcurrency, prefetch), flux.flatMapSequentialDelayError(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}), maxConcurrency, prefetch), flux.switchMap(x -> (Publisher)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}))});
        }

        Flux<S> after(Flux<T> flux) {
            return flux.mapNotNull(x -> this.transformation(x));
        }
    }

    static abstract class MonoMapNotNull<T, S> {
        MonoMapNotNull() {
        }

        abstract S transformation(T var1);

        Mono<S> before(Mono<T> mono) {
            return mono.flatMap(x -> (Mono)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(this.transformation(x)), Mono.fromSupplier(() -> this.transformation(x))}));
        }

        Mono<S> after(Mono<T> mono) {
            return mono.mapNotNull(x -> this.transformation(x));
        }
    }

    static abstract class FluxMap<T, S> {
        FluxMap() {
        }

        abstract S transformation(T var1);

        Flux<S> before(Flux<T> flux, int prefetch, boolean delayUntilEnd, int maxConcurrency) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.concatMap(x -> Mono.just(this.transformation(x))), flux.concatMap(x -> Flux.just(this.transformation(x))), flux.concatMap(x -> Mono.just(this.transformation(x)), prefetch), flux.concatMap(x -> Flux.just(this.transformation(x)), prefetch), flux.concatMapDelayError(x -> Mono.just(this.transformation(x))), flux.concatMapDelayError(x -> Flux.just(this.transformation(x))), flux.concatMapDelayError(x -> Mono.just(this.transformation(x)), prefetch), flux.concatMapDelayError(x -> Flux.just(this.transformation(x)), prefetch), flux.concatMapDelayError(x -> Mono.just(this.transformation(x)), delayUntilEnd, prefetch), flux.concatMapDelayError(x -> Flux.just(this.transformation(x)), delayUntilEnd, prefetch), flux.flatMap(x -> Mono.just(this.transformation(x)), maxConcurrency), flux.flatMap(x -> Flux.just(this.transformation(x)), maxConcurrency), flux.flatMap(x -> Mono.just(this.transformation(x)), maxConcurrency, prefetch), flux.flatMap(x -> Flux.just(this.transformation(x)), maxConcurrency, prefetch), flux.flatMapDelayError(x -> Mono.just(this.transformation(x)), maxConcurrency, prefetch), flux.flatMapDelayError(x -> Flux.just(this.transformation(x)), maxConcurrency, prefetch), flux.flatMapSequential(x -> Mono.just(this.transformation(x)), maxConcurrency), flux.flatMapSequential(x -> Flux.just(this.transformation(x)), maxConcurrency), flux.flatMapSequential(x -> Mono.just(this.transformation(x)), maxConcurrency, prefetch), flux.flatMapSequential(x -> Flux.just(this.transformation(x)), maxConcurrency, prefetch), flux.flatMapSequentialDelayError(x -> Mono.just(this.transformation(x)), maxConcurrency, prefetch), flux.flatMapSequentialDelayError(x -> Flux.just(this.transformation(x)), maxConcurrency, prefetch), flux.switchMap(x -> Mono.just(this.transformation(x))), flux.switchMap(x -> Flux.just(this.transformation(x)))});
        }

        Flux<S> after(Flux<T> flux) {
            return flux.map(x -> this.transformation(x));
        }
    }

    static abstract class MonoMap<T, S> {
        MonoMap() {
        }

        abstract S transformation(T var1);

        Mono<S> before(Mono<T> mono) {
            return mono.flatMap(x -> Mono.just(this.transformation(x)));
        }

        Mono<S> after(Mono<T> mono) {
            return mono.map(x -> this.transformation(x));
        }
    }

    static abstract class MonoFlatMapToFlux<T, S> {
        MonoFlatMapToFlux() {
        }

        abstract Mono<S> transformation(T var1);

        Flux<S> before(Mono<T> mono) {
            return mono.flatMapMany(v -> this.transformation(v));
        }

        Flux<S> after(Mono<T> mono) {
            return mono.flatMap(v -> this.transformation(v)).flux();
        }
    }

    static final class FluxConcatMapIterableWithPrefetch<T, S, I extends Iterable<? extends S>> {
        FluxConcatMapIterableWithPrefetch() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, I> function, int prefetch, Function<? super I, ? extends Iterable<? extends S>> identityOperation) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.flatMapIterable(function, prefetch), flux.map(function).concatMapIterable(identityOperation, prefetch)});
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends Iterable<? extends S>> function, int prefetch) {
            return flux.concatMapIterable(function, prefetch);
        }
    }

    static final class FluxConcatMapIterable<T, S, I extends Iterable<? extends S>> {
        FluxConcatMapIterable() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, I> function, Function<? super I, ? extends Iterable<? extends S>> identityOperation) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.flatMapIterable(function), flux.map(function).concatMapIterable(identityOperation)});
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends Iterable<? extends S>> function) {
            return flux.concatMapIterable(function);
        }
    }

    static final class MonoFlatMapIterableIdentity<T, S extends Iterable<T>> {
        MonoFlatMapIterableIdentity() {
        }

        Flux<T> before(Mono<S> mono) {
            return mono.flatMapMany(Flux::fromIterable);
        }

        Flux<T> after(Mono<S> mono) {
            return mono.flatMapIterable(Function.identity());
        }
    }

    static final class MonoFlatMapIterable<T, S, I extends Iterable<? extends S>> {
        MonoFlatMapIterable() {
        }

        Flux<S> before(Mono<T> mono, Function<? super T, I> function) {
            return mono.map(function).flatMapMany(Flux::fromIterable);
        }

        Flux<S> before(Mono<T> mono, Function<? super T, I> function, Function<? super I, ? extends Iterable<? extends S>> identityOperation) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{mono.map(function).flatMapIterable(identityOperation), mono.flux().concatMapIterable(function)});
        }

        Flux<S> after(Mono<T> mono, Function<? super T, I> function) {
            return mono.flatMapIterable(function);
        }
    }

    static final class FluxConcatMapWithPrefetch<T, S, P extends Publisher<? extends S>> {
        FluxConcatMapWithPrefetch() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, ? extends P> function, int prefetch, Function<? super P, ? extends Publisher<? extends S>> identityOperation) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.flatMap(function, 1, prefetch), flux.flatMapSequential(function, 1, prefetch), flux.map(function).concatMap(identityOperation, prefetch)});
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends P> function, int prefetch) {
            return flux.concatMap(function, prefetch);
        }
    }

    static final class FluxConcatMap<T, S, P extends Publisher<? extends S>> {
        FluxConcatMap() {
        }

        Flux<S> before(Flux<T> flux, Function<? super T, ? extends P> function, Function<? super P, ? extends Publisher<? extends S>> identityOperation) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{flux.flatMap(function, 1), flux.flatMapSequential(function, 1), flux.map(function).concatMap(identityOperation)});
        }

        Flux<S> after(Flux<T> flux, Function<? super T, ? extends P> function) {
            return flux.concatMap(function);
        }
    }

    static final class FluxSwitchIfEmptyOfEmptyPublisher<T> {
        FluxSwitchIfEmptyOfEmptyPublisher() {
        }

        Flux<T> before(Flux<T> flux) {
            return flux.switchIfEmpty((Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.empty(), Flux.empty()}));
        }

        @CanIgnoreReturnValue
        Flux<T> after(Flux<T> flux) {
            return flux;
        }
    }

    static final class MonoSingle<T> {
        MonoSingle() {
        }

        Mono<T> before(Mono<T> mono) {
            return mono.flux().single();
        }

        Mono<T> after(Mono<T> mono) {
            return mono.single();
        }
    }

    static final class MonoIdentity<T> {
        MonoIdentity() {
        }

        Mono<T> before(Mono<T> mono) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{mono.switchIfEmpty(Mono.empty()), mono.flux().next(), mono.flux().singleOrEmpty()});
        }

        Mono<@Nullable Void> before2(Mono<@Nullable Void> mono) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{mono.ignoreElement(), mono.then()});
        }

        Mono<ImmutableList<T>> before3(Mono<ImmutableList<T>> mono) {
            return mono.map(ImmutableList::copyOf);
        }

        @CanIgnoreReturnValue
        Mono<T> after(Mono<T> mono) {
            return mono;
        }
    }

    static final class FluxJust {
        FluxJust() {
        }

        Flux<Integer> before(int start) {
            return Flux.range((int)start, (int)1);
        }

        Flux<Integer> after(int start) {
            return Flux.just((Object)start);
        }
    }

    static final class FluxEmpty<T, S extends Comparable<? super S>> {
        FluxEmpty() {
        }

        Flux<T> before(Function<? super Object[], ? extends T> combinator, int prefetch, Comparator<? super T> comparator) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{Flux.zip(combinator, (Publisher[])new Publisher[0]), Flux.zip(combinator, (int)prefetch, (Publisher[])new Publisher[0]), Flux.concat((Publisher[])new Publisher[0]), Flux.concatDelayError((Publisher[])new Publisher[0]), Flux.firstWithSignal((Publisher[])new Publisher[0]), Flux.just((Object[])new Object[0]), Flux.merge((Publisher[])new Publisher[0]), Flux.merge((int)prefetch, (Publisher[])new Publisher[0]), Flux.mergeComparing(comparator, (Publisher[])new Publisher[0]), Flux.mergeComparing((int)prefetch, comparator, (Publisher[])new Publisher[0]), Flux.mergeComparingDelayError((int)prefetch, comparator, (Publisher[])new Publisher[0]), Flux.mergeDelayError((int)prefetch, (Publisher[])new Publisher[0]), Flux.mergePriority(comparator, (Publisher[])new Publisher[0]), Flux.mergePriority((int)prefetch, comparator, (Publisher[])new Publisher[0]), Flux.mergePriorityDelayError((int)prefetch, comparator, (Publisher[])new Publisher[0]), Flux.mergeSequential((Publisher[])new Publisher[0]), Flux.mergeSequential((int)prefetch, (Publisher[])new Publisher[0]), Flux.mergeSequentialDelayError((int)prefetch, (Publisher[])new Publisher[0])});
        }

        Flux<T> before(Function<Object[], T> combinator, int prefetch) {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{Flux.combineLatest(combinator, (Publisher[])new Publisher[0]), Flux.combineLatest(combinator, (int)prefetch, (Publisher[])new Publisher[0])});
        }

        Flux<S> before() {
            return (Flux)Refaster.anyOf((Object[])new Flux[]{Flux.mergeComparing((Publisher[])new Publisher[0]), Flux.mergePriority((Publisher[])new Publisher[0])});
        }

        Flux<Integer> before(int start) {
            return Flux.range((int)start, (int)0);
        }

        Flux<T> after() {
            return Flux.empty();
        }
    }

    static final class FluxDefaultIfEmpty<T> {
        FluxDefaultIfEmpty() {
        }

        Flux<T> before(Flux<T> flux, T object) {
            return flux.switchIfEmpty((Publisher)Refaster.anyOf((Object[])new CorePublisher[]{Mono.just(object), Flux.just(object)}));
        }

        Flux<T> after(Flux<T> flux, T object) {
            return flux.defaultIfEmpty(object);
        }
    }

    static final class MonoDefaultIfEmpty<T> {
        MonoDefaultIfEmpty() {
        }

        Mono<T> before(Mono<T> mono, T object) {
            return mono.switchIfEmpty(Mono.just(object));
        }

        Mono<T> after(Mono<T> mono, T object) {
            return mono.defaultIfEmpty(object);
        }
    }

    static final class FluxTake<T> {
        FluxTake() {
        }

        Flux<T> before(Flux<T> flux, long n) {
            return flux.take(n);
        }

        Flux<T> after(Flux<T> flux, long n) {
            return flux.take(n, true);
        }
    }

    static final class MonoThenReturn<T, S> {
        MonoThenReturn() {
        }

        Mono<S> before(Mono<T> mono, S object) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{mono.ignoreElement().thenReturn(object), mono.then().thenReturn(object), mono.then(Mono.just(object))});
        }

        Mono<S> after(Mono<T> mono, S object) {
            return mono.thenReturn(object);
        }
    }

    static final class FluxErrorSupplier<T, E extends Throwable> {
        FluxErrorSupplier() {
        }

        Flux<T> before(Supplier<E> supplier) {
            return Flux.error(() -> (Throwable)supplier.get());
        }

        Flux<T> after(Supplier<E> supplier) {
            return Flux.error(supplier);
        }
    }

    static final class MonoErrorSupplier<T, E extends Throwable> {
        MonoErrorSupplier() {
        }

        Mono<T> before(Supplier<E> supplier) {
            return Mono.error(() -> (Throwable)supplier.get());
        }

        Mono<T> after(Supplier<E> supplier) {
            return Mono.error(supplier);
        }
    }

    static final class FluxDeferredError<T> {
        FluxDeferredError() {
        }

        Flux<T> before(Throwable throwable) {
            return Flux.defer(() -> Flux.error((Throwable)throwable));
        }

        Flux<T> after(Throwable throwable) {
            return Flux.error(() -> throwable);
        }
    }

    static final class MonoDeferredError<T> {
        MonoDeferredError() {
        }

        Mono<T> before(Throwable throwable) {
            return Mono.defer(() -> Mono.error((Throwable)throwable));
        }

        Mono<T> after(Throwable throwable) {
            return Mono.error(() -> throwable);
        }
    }

    static final class FluxZipWithIterableMapFunction<T, S, R> {
        FluxZipWithIterableMapFunction() {
        }

        Flux<R> before(Flux<T> flux, Iterable<S> iterable, BiFunction<T, S, R> combinator) {
            return flux.zipWithIterable(iterable, combinator);
        }

        Flux<R> after(Flux<T> flux, Iterable<S> iterable, BiFunction<T, S, R> combinator) {
            return flux.zipWithIterable(iterable).map(TupleUtils.function(combinator));
        }
    }

    static final class FluxZipWithIterableBiFunction<T, S, R> {
        FluxZipWithIterableBiFunction() {
        }

        Flux<R> before(Flux<T> flux, Iterable<S> iterable, BiFunction<? super T, ? super S, ? extends R> function) {
            return flux.zipWith((Publisher)Flux.fromIterable(iterable), function);
        }

        Flux<R> after(Flux<T> flux, Iterable<S> iterable, BiFunction<? super T, ? super S, ? extends R> function) {
            return flux.zipWithIterable(iterable, function);
        }
    }

    static final class FluxZipWithIterable<T, S> {
        FluxZipWithIterable() {
        }

        Flux<Tuple2<T, S>> before(Flux<T> flux, Iterable<S> iterable) {
            return Flux.zip(flux, (Publisher)Flux.fromIterable(iterable));
        }

        Flux<Tuple2<T, S>> after(Flux<T> flux, Iterable<S> iterable) {
            return flux.zipWithIterable(iterable);
        }
    }

    static final class FluxZipWithCombinator<T, S, R> {
        FluxZipWithCombinator() {
        }

        Flux<R> before(Flux<T> flux, Publisher<S> other, BiFunction<T, S, R> combinator) {
            return flux.zipWith(other, combinator);
        }

        Flux<R> after(Flux<T> flux, Publisher<S> other, BiFunction<T, S, R> combinator) {
            return Flux.zip(flux, other).map(TupleUtils.function(combinator));
        }
    }

    static final class FluxZip<T, S> {
        FluxZip() {
        }

        Flux<Tuple2<T, S>> before(Flux<T> flux, Publisher<S> other) {
            return flux.zipWith(other);
        }

        Flux<Tuple2<T, S>> after(Flux<T> flux, Publisher<S> other) {
            return Flux.zip(flux, other);
        }
    }

    static final class MonoZipWithCombinator<T, S, R> {
        MonoZipWithCombinator() {
        }

        Mono<R> before(Mono<T> mono, Mono<S> other, BiFunction<T, S, R> combinator) {
            return mono.zipWith(other, combinator);
        }

        Mono<R> after(Mono<T> mono, Mono<S> other, BiFunction<T, S, R> combinator) {
            return Mono.zip(mono, other).map(TupleUtils.function(combinator));
        }
    }

    static final class MonoZip<T, S> {
        MonoZip() {
        }

        Mono<Tuple2<T, S>> before(Mono<T> mono, Mono<S> other) {
            return mono.zipWith(other);
        }

        Mono<Tuple2<T, S>> after(Mono<T> mono, Mono<S> other) {
            return Mono.zip(mono, other);
        }
    }

    static final class MonoFromOptionalSwitchIfEmpty<T> {
        MonoFromOptionalSwitchIfEmpty() {
        }

        Mono<T> before(Optional<T> optional, Mono<T> mono) {
            return optional.map(Mono::just).orElse(mono);
        }

        Mono<T> after(Optional<T> optional, Mono<T> mono) {
            return Mono.justOrEmpty(optional).switchIfEmpty(mono);
        }
    }

    static final class OptionalMapMonoJust<T> {
        OptionalMapMonoJust() {
        }

        Optional<Mono<T>> before(Optional<T> optional) {
            return optional.map(Mono::justOrEmpty);
        }

        Optional<Mono<T>> after(Optional<T> optional) {
            return optional.map(Mono::just);
        }
    }

    static final class MonoDeferMonoJustOrEmpty<T> {
        MonoDeferMonoJustOrEmpty() {
        }

        Mono<T> before(Optional<T> optional) {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{Mono.fromCallable(() -> optional.orElse(null)), Mono.fromSupplier(() -> optional.orElse(null))});
        }

        Mono<T> after(Optional<T> optional) {
            return Mono.defer(() -> Mono.justOrEmpty((Optional)optional));
        }
    }

    static final class MonoJustOrEmptyOptional<T> {
        MonoJustOrEmptyOptional() {
        }

        Mono<T> before(Optional<T> optional) {
            return Mono.just(optional).filter(Optional::isPresent).map(Optional::orElseThrow);
        }

        Mono<T> after(Optional<T> optional) {
            return Mono.justOrEmpty(optional);
        }
    }

    static final class MonoJustOrEmptyObject<T> {
        MonoJustOrEmptyObject() {
        }

        Mono<T> before(T value) {
            return Mono.justOrEmpty(Optional.ofNullable(value));
        }

        Mono<T> after(T value) {
            return Mono.justOrEmpty(value);
        }
    }

    static final class MonoJust<T> {
        MonoJust() {
        }

        Mono<T> before(T value) {
            return Mono.justOrEmpty(Optional.of(value));
        }

        Mono<T> after(T value) {
            return Mono.just(value);
        }
    }

    static final class MonoEmpty<T> {
        MonoEmpty() {
        }

        Mono<T> before() {
            return (Mono)Refaster.anyOf((Object[])new Mono[]{Mono.justOrEmpty(null), Mono.justOrEmpty(Optional.empty())});
        }

        Mono<T> after() {
            return Mono.empty();
        }
    }

    static final class MonoFromSupplier<T> {
        MonoFromSupplier() {
        }

        Mono<T> before(Callable<? extends T> supplier) {
            return Mono.fromCallable(supplier);
        }

        Mono<T> after(Supplier<? extends T> supplier) {
            return Mono.fromSupplier(supplier);
        }
    }
}

