/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.IntStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class IntStreamRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to expressions dealing with `IntStream`s";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.IntStreamRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new IntStreamClosedOpenRangeRecipe(), new ConcatOneIntStreamRecipe(), new ConcatTwoIntStreamsRecipe(), new IntStreamFilterSortedRecipe(), new IntStreamMinRecipe(), new IntStreamAllMatchRecipe(), new IntStreamTakeWhileRecipe()});
    }

    @NonNullApi
    public static class IntStreamClosedOpenRangeRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `IntStream#range(int, int)` over the more contrived alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamClosedOpenRange {\n    \n    @BeforeTemplate\n    IntStream before(int from, int to) {\n        return IntStream.rangeClosed(from, to - 1);\n    }\n    \n    @AfterTemplate\n    IntStream after(int from, int to) {\n        return IntStream.range(from, to);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (from, to) -> IntStream.rangeClosed(from, to - 1)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (from, to) -> IntStream.range(from, to)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream rangeClosed(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConcatOneIntStreamRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Don't unnecessarily call `Streams#concat(IntStream...)`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatOneIntStream {\n    \n    @BeforeTemplate\n    IntStream before(IntStream stream) {\n        return Streams.concat(stream);\n    }\n    \n    @AfterTemplate\n    @CanIgnoreReturnValue\n    IntStream after(IntStream stream) {\n        return stream;\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", stream -> Streams.concat((IntStream[])new IntStream[]{stream})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", stream -> stream).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConcatTwoIntStreamsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `IntStream#concat(IntStream, IntStream)` over the Guava alternative";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConcatTwoIntStreams {\n    \n    @BeforeTemplate\n    IntStream before(IntStream s1, IntStream s2) {\n        return Streams.concat(s1, s2);\n    }\n    \n    @AfterTemplate\n    IntStream after(IntStream s1, IntStream s2) {\n        return IntStream.concat(s1, s2);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (s1, s2) -> Streams.concat((IntStream[])new IntStream[]{s1, s2})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (s1, s2) -> IntStream.concat(s1, s2)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.google.common.collect.Streams");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.Streams", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.Streams concat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntStreamFilterSortedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Apply `IntStream#filter(IntPredicate)` before `IntStream#sorted()` to reduce the number of elements to sort";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamFilterSorted {\n    \n    @BeforeTemplate\n    IntStream before(IntStream stream, IntPredicate predicate) {\n        return stream.sorted().filter(predicate);\n    }\n    \n    @AfterTemplate\n    IntStream after(IntStream stream, IntPredicate predicate) {\n        return stream.filter(predicate).sorted();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.sorted().filter((IntPredicate)predicate)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.filter((IntPredicate)predicate).sorted()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream filter(..)"), new UsesMethod("java.util.stream.IntStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntStreamMinRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamMin`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamMin {\n    \n    @BeforeTemplate\n    OptionalInt before(IntStream stream) {\n        return stream.sorted().findFirst();\n    }\n    \n    @AfterTemplate\n    OptionalInt after(IntStream stream) {\n        return stream.min();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", stream -> stream.sorted().findFirst()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", stream -> stream.min()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalInt", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream findFirst(..)"), new UsesMethod("java.util.stream.IntStream sorted(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntStreamAllMatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamAllMatch`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamAllMatch {\n    \n    @BeforeTemplate\n    boolean before(IntStream stream, IntPredicate predicate) {\n        return stream.noneMatch(predicate.negate());\n    }\n    \n    @AfterTemplate\n    boolean after(IntStream stream, IntPredicate predicate) {\n        return stream.allMatch(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.noneMatch(predicate.negate())).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.allMatch((IntPredicate)predicate)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES, AbstractRefasterJavaVisitor.EmbeddingOption.SIMPLIFY_BOOLEANS});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream noneMatch(..)"), new UsesMethod("java.util.function.IntPredicate negate(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class IntStreamTakeWhileRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `IntStreamRules.IntStreamTakeWhile`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class IntStreamTakeWhile {\n    \n    @BeforeTemplate\n    IntStream before(IntStream stream, IntPredicate predicate) {\n        return stream.takeWhile(predicate).filter(predicate);\n    }\n    \n    @AfterTemplate\n    IntStream after(IntStream stream, IntPredicate predicate) {\n        return stream.takeWhile(predicate);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (stream, predicate) -> stream.takeWhile((IntPredicate)predicate).filter((IntPredicate)predicate)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (stream, predicate) -> stream.takeWhile((IntPredicate)predicate)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.function.IntPredicate", Boolean.valueOf(true)), new UsesType("java.util.stream.IntStream", Boolean.valueOf(true)), new UsesMethod("java.util.stream.IntStream filter(..)"), new UsesMethod("java.util.stream.IntStream takeWhile(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

