/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.Convert;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class BugCheckerRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Refaster rules related to `com.google.errorprone.bugpatterns.BugChecker` classes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.BugCheckerRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe(), new ConstantsFormatRecipe()});
    }

    @NonNullApi
    public static class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchangedRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer `BugCheckerRefactoringTestHelper.ExpectOutput#expectUnchanged()` over repeating the input";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class BugCheckerRefactoringTestHelperAddInputLinesExpectUnchanged {\n    \n    @BeforeTemplate\n    BugCheckerRefactoringTestHelper before(BugCheckerRefactoringTestHelper helper, String path, String source) {\n        return helper.addInputLines(path, source).addOutputLines(path, source);\n    }\n    \n    @AfterTemplate\n    BugCheckerRefactoringTestHelper after(BugCheckerRefactoringTestHelper helper, String path, String source) {\n        return helper.addInputLines(path, source).expectUnchanged();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (helper, path, source) -> helper.addInputLines(path, new String[]{source}).addOutputLines(path, new String[]{source})).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (helper, path, source) -> helper.addInputLines(path, new String[]{source}).expectUnchanged()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.errorprone.BugCheckerRefactoringTestHelper", Boolean.valueOf(true)), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper.ExpectOutput addOutputLines(..)"), new UsesMethod("com.google.errorprone.BugCheckerRefactoringTestHelper addInputLines(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class ConstantsFormatRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Prefer using the `Constants` API over more verbose alternatives";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class ConstantsFormat {\n    \n    @BeforeTemplate\n    String before(String value) {\n        return String.format(\"\\\"%s\\\"\", Convert.quote(value));\n    }\n    \n    @AfterTemplate\n    String after(String value) {\n        return Constants.format(value);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", value -> String.format("\"%s\"", Convert.quote(value))).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", value -> Constants.format(value)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("com.sun.tools.javac.util.Convert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.sun.tools.javac.util.Convert", Boolean.valueOf(true)), new UsesMethod("java.lang.String format(..)"), new UsesMethod("com.sun.tools.javac.util.Convert quote(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

