/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJByteRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJByteRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJByteRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractByteAssertIsZeroRecipe(), new AbstractByteAssertIsNotZeroRecipe(), new AbstractByteAssertIsOneRecipe()});
    }

    @NonNullApi
    public static class AbstractByteAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isEqualTo((byte)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", byteAssert -> byteAssert.isZero()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", byteAssert -> byteAssert.isEqualTo((byte)0)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractByteAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsNotZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isNotEqualTo((byte)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", byteAssert -> byteAssert.isNotZero()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", byteAssert -> byteAssert.isNotEqualTo((byte)0)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isNotZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractByteAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJByteRules.AbstractByteAssertIsOne`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractByteAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractByteAssert<?> before(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractByteAssert<?> after(AbstractByteAssert<?> byteAssert) {\n        return byteAssert.isEqualTo((byte)1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", byteAssert -> byteAssert.isOne()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", byteAssert -> byteAssert.isEqualTo((byte)1)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractByteAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractByteAssert isOne(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

