/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.Semantics;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJBooleanRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJBooleanRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJBooleanRules`.";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractBooleanAssertIsEqualToRecipe(), new AbstractBooleanAssertIsNotEqualToRecipe(), new AssertThatBooleanIsTrueRecipe(), new AssertThatBooleanIsFalseRecipe()});
    }

    @NonNullApi
    public static class AbstractBooleanAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AbstractBooleanAssertIsEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBooleanAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isNotEqualTo(!other);\n    }\n    \n    @AfterTemplate\n    AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isEqualTo(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (boolAssert, other) -> boolAssert.isNotEqualTo(other == false)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (boolAssert, other) -> boolAssert.isEqualTo(other)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isNotEqualTo(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractBooleanAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AbstractBooleanAssertIsNotEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractBooleanAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isEqualTo(!other);\n    }\n    \n    @AfterTemplate\n    AbstractBooleanAssert<?> after(AbstractBooleanAssert<?> boolAssert, boolean other) {\n        return boolAssert.isNotEqualTo(other);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", (boolAssert, other) -> boolAssert.isEqualTo(other == false)).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", (boolAssert, other) -> boolAssert.isNotEqualTo(other)).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isEqualTo(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatBooleanIsTrueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AssertThatBooleanIsTrue`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanIsTrue {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean b) {\n        return assertThat(!b).isFalse();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean b) {\n        return assertThat(b).isTrue();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", b -> Assertions.assertThat((b == false ? 1 : 0) != 0).isFalse()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", b -> Assertions.assertThat((Boolean)b).isTrue()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isFalse(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AssertThatBooleanIsFalseRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJBooleanRules.AssertThatBooleanIsFalse`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatBooleanIsFalse {\n    \n    @BeforeTemplate\n    AbstractBooleanAssert<?> before(boolean b) {\n        return assertThat(!b).isTrue();\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    AbstractBooleanAssert<?> after(boolean b) {\n        return assertThat(b).isFalse();\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = Semantics.expression((JavaVisitor)this, (String)"before", b -> Assertions.assertThat((b == false ? 1 : 0) != 0).isTrue()).build();
                final JavaTemplate after = Semantics.expression((JavaVisitor)this, (String)"after", b -> Assertions.assertThat((Boolean)b).isFalse()).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractBooleanAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractBooleanAssert isTrue(..)"), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

