/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.primitives.Primitives;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.TypesWithUndefinedEquality;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Arrays;
import java.util.List;
import tech.picnic.errorprone.utils.SourceCode;

@BugPattern(summary="Avoid or clarify identity conversions", link="https://error-prone.picnic.tech/bugpatterns/IdentityConversion", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class IdentityConversion
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> IS_CONVERSION_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClassAny((Iterable)Primitives.allWrapperTypes().stream().map(Class::getName).collect(ImmutableSet.toImmutableSet())).named("valueOf"), Matchers.staticMethod().onClass(String.class.getCanonicalName()).named("valueOf"), Matchers.staticMethod().onClassAny(new String[]{ImmutableBiMap.class.getCanonicalName(), ImmutableList.class.getCanonicalName(), ImmutableListMultimap.class.getCanonicalName(), ImmutableMap.class.getCanonicalName(), ImmutableMultimap.class.getCanonicalName(), ImmutableMultiset.class.getCanonicalName(), ImmutableRangeMap.class.getCanonicalName(), ImmutableRangeSet.class.getCanonicalName(), ImmutableSet.class.getCanonicalName(), ImmutableSetMultimap.class.getCanonicalName(), ImmutableTable.class.getCanonicalName()}).named("copyOf"), Matchers.staticMethod().onClass(Matchers.class.getCanonicalName()).namedAnyOf(new String[]{"allOf", "anyOf"}), Matchers.staticMethod().onClass("reactor.adapter.rxjava.RxJava2Adapter"), Matchers.staticMethod().onClass("reactor.core.publisher.Flux").namedAnyOf(new String[]{"concat", "firstWithSignal", "from", "merge"}), Matchers.staticMethod().onClass("reactor.core.publisher.Mono").namedAnyOf(new String[]{"from", "fromDirect"})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.size() != 1 || !IS_CONVERSION_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree sourceTree = arguments.get(0);
        Type sourceType = ASTHelpers.getType((Tree)sourceTree);
        Type resultType = ASTHelpers.getType((Tree)tree);
        ASTHelpers.TargetType targetType = ASTHelpers.targetType((VisitorState)state);
        if (sourceType == null || resultType == null || targetType == null) {
            return Description.NO_MATCH;
        }
        if (!state.getTypes().isSameType(sourceType, resultType) && !IdentityConversion.isConvertibleWithWellDefinedEquality(sourceType, targetType.type(), state)) {
            return Description.NO_MATCH;
        }
        if (sourceType.isPrimitive() && state.getPath().getParentPath().getLeaf() instanceof MemberSelectTree) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("This method invocation appears redundant; remove it or suppress this warning and add a comment explaining its purpose").addFix((Fix)SuggestedFix.replace((Tree)tree, (String)SourceCode.treeToString((Tree)sourceTree, (VisitorState)state))).addFix((Fix)SuggestedFixes.addSuppressWarnings((VisitorState)state, (String)this.canonicalName())).build();
    }

    private static boolean isConvertibleWithWellDefinedEquality(Type sourceType, Type targetType, VisitorState state) {
        Types types = state.getTypes();
        return !types.isSameType(targetType, (Type)Suppliers.OBJECT_TYPE.get(state)) && types.isConvertible(sourceType, targetType) && Arrays.stream(TypesWithUndefinedEquality.values()).noneMatch(b -> b.matchesType(sourceType, state) || b.matchesType(targetType, state));
    }
}

