/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.refaster.Refaster;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

final class EqualityRules {
    private EqualityRules() {
    }

    static final class EqualsLhsAndRhsNullable<T, S> {
        EqualsLhsAndRhsNullable() {
        }

        boolean before(T value1, S value2) {
            return Optional.ofNullable(value1).equals(Optional.ofNullable(value2));
        }

        boolean after(T value1, S value2) {
            return Objects.equals(value1, value2);
        }
    }

    static final class EqualsRhsNullable<T, S> {
        EqualsRhsNullable() {
        }

        boolean before(T value1, S value2) {
            return Optional.of(value1).equals(Optional.ofNullable(value2));
        }

        boolean after(T value1, S value2) {
            return value1.equals(value2);
        }
    }

    static final class EqualsLhsNullable<T, S> {
        EqualsLhsNullable() {
        }

        boolean before(T value1, S value2) {
            return Optional.ofNullable(value1).equals(Optional.of(value2));
        }

        boolean after(T value1, S value2) {
            return value2.equals(value1);
        }
    }

    static abstract class PredicateLambda<T> {
        PredicateLambda() {
        }

        abstract boolean predicate(T var1);

        Predicate<T> before() {
            return Predicate.not(v -> this.predicate(v));
        }

        Predicate<T> after() {
            return v -> !this.predicate(v);
        }
    }

    static final class IndirectDoubleNegation {
        IndirectDoubleNegation() {
        }

        boolean before(boolean a, boolean b) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{a == b, a ? b : !b});
        }

        boolean before(double a, double b) {
            return a == b;
        }

        boolean before(Object a, Object b) {
            return a == b;
        }

        boolean after(boolean a, boolean b) {
            return a == b;
        }
    }

    static final class Negation {
        Negation() {
        }

        boolean before(boolean a, boolean b) {
            Object[] objectArray = new Boolean[2];
            objectArray[0] = a != b;
            objectArray[1] = a ? !b : b;
            return (Boolean)Refaster.anyOf((Object[])objectArray);
        }

        boolean before(double a, double b) {
            return a != b;
        }

        boolean before(Object a, Object b) {
            return a != b;
        }

        boolean after(boolean a, boolean b) {
            return a != b;
        }
    }

    static final class DoubleNegation {
        DoubleNegation() {
        }

        boolean before(boolean b) {
            return b;
        }

        @CanIgnoreReturnValue
        boolean after(boolean b) {
            return b;
        }
    }

    static final class EqualsPredicate<T> {
        EqualsPredicate() {
        }

        Predicate<T> before(T v) {
            return e -> v.equals(e);
        }

        Predicate<T> after(T v) {
            return v::equals;
        }
    }

    static final class PrimitiveOrReferenceEquality<T extends Enum<T>> {
        PrimitiveOrReferenceEquality() {
        }

        boolean before(T a, T b) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{((Enum)a).equals(b), Objects.equals(a, b)});
        }

        boolean after(T a, T b) {
            return a == b;
        }
    }
}

