/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.refaster.Refaster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;

final class CollectionRules {
    private CollectionRules() {
    }

    static final class CollectionForEach<T> {
        CollectionForEach() {
        }

        void before(Collection<T> collection, Consumer<? super T> consumer) {
            collection.stream().forEach(consumer);
        }

        void after(Collection<T> collection, Consumer<? super T> consumer) {
            collection.forEach(consumer);
        }
    }

    static final class RemoveOptionalFirstQueueElement<T> {
        RemoveOptionalFirstQueueElement() {
        }

        Optional<T> before(Queue<T> queue) {
            return queue.isEmpty() ? Optional.empty() : (Optional)Refaster.anyOf((Object[])new Optional[]{Optional.of(Refaster.anyOf((Object[])new Object[]{queue.poll(), queue.remove()})), Optional.ofNullable(Refaster.anyOf((Object[])new Object[]{queue.poll(), queue.remove()}))});
        }

        Optional<T> after(Queue<T> queue) {
            return Optional.ofNullable(queue.poll());
        }
    }

    static final class RemoveOptionalFirstNavigableSetElement<T> {
        RemoveOptionalFirstNavigableSetElement() {
        }

        Optional<T> before(NavigableSet<T> set) {
            return set.isEmpty() ? Optional.empty() : (Optional)Refaster.anyOf((Object[])new Optional[]{Optional.of(set.pollFirst()), Optional.ofNullable(set.pollFirst())});
        }

        Optional<T> after(NavigableSet<T> set) {
            return Optional.ofNullable(set.pollFirst());
        }
    }

    static final class OptionalFirstQueueElement<T> {
        OptionalFirstQueueElement() {
        }

        Optional<T> before(Queue<T> queue) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{queue.stream().findFirst(), queue.isEmpty() ? Optional.empty() : (Optional)Refaster.anyOf((Object[])new Optional[]{Optional.of(queue.peek()), Optional.ofNullable(queue.peek())})});
        }

        Optional<T> after(Queue<T> queue) {
            return Optional.ofNullable(queue.peek());
        }
    }

    static final class OptionalFirstCollectionElement<T> {
        OptionalFirstCollectionElement() {
        }

        Optional<T> before(Collection<T> collection) {
            return (Optional)Refaster.anyOf((Object[])new Optional[]{collection.stream().findAny(), collection.isEmpty() ? Optional.empty() : Optional.of(collection.iterator().next())});
        }

        Optional<T> before(List<T> collection) {
            return collection.isEmpty() ? Optional.empty() : Optional.of(collection.get(0));
        }

        Optional<T> before(SortedSet<T> collection) {
            return collection.isEmpty() ? Optional.empty() : Optional.of(collection.first());
        }

        Optional<T> after(Collection<T> collection) {
            return collection.stream().findFirst();
        }
    }

    static final class ImmutableCollectionIterator<T> {
        ImmutableCollectionIterator() {
        }

        Iterator<T> before(ImmutableCollection<T> collection) {
            return collection.asList().iterator();
        }

        Iterator<T> after(ImmutableCollection<T> collection) {
            return collection.iterator();
        }
    }

    static final class ImmutableCollectionToArrayWithGenerator<T, S> {
        ImmutableCollectionToArrayWithGenerator() {
        }

        S[] before(ImmutableCollection<T> collection, IntFunction<S[]> generator) {
            return collection.asList().toArray(generator);
        }

        S[] after(ImmutableCollection<T> collection, IntFunction<S[]> generator) {
            return collection.toArray(generator);
        }
    }

    static final class ImmutableCollectionToArrayWithArray<T, S> {
        ImmutableCollectionToArrayWithArray() {
        }

        Object[] before(ImmutableCollection<T> collection, S[] array) {
            return collection.asList().toArray((Object[])array);
        }

        Object[] after(ImmutableCollection<T> collection, S[] array) {
            return collection.toArray((Object[])array);
        }
    }

    static final class CollectionToArray<T> {
        CollectionToArray() {
        }

        Object[] before(Collection<T> collection, int size) {
            return (Object[])Refaster.anyOf((Object[])new Object[][]{collection.toArray(new Object[size]), collection.toArray(Object[]::new)});
        }

        Object[] before(ImmutableCollection<T> collection) {
            return collection.asList().toArray();
        }

        Object[] after(Collection<T> collection) {
            return collection.toArray();
        }
    }

    static final class ImmutableCollectionToString<T> {
        ImmutableCollectionToString() {
        }

        String before(ImmutableCollection<T> collection) {
            return collection.asList().toString();
        }

        String after(ImmutableCollection<T> collection) {
            return collection.toString();
        }
    }

    static final class ImmutableCollectionParallelStream<T> {
        ImmutableCollectionParallelStream() {
        }

        Stream<T> before(ImmutableCollection<T> collection) {
            return collection.asList().parallelStream();
        }

        Stream<T> after(ImmutableCollection<T> collection) {
            return collection.parallelStream();
        }
    }

    static final class ImmutableCollectionContains<T, S> {
        ImmutableCollectionContains() {
        }

        boolean before(ImmutableCollection<T> collection, S elem) {
            return collection.asList().contains(elem);
        }

        boolean after(ImmutableCollection<T> collection, S elem) {
            return collection.contains(elem);
        }
    }

    static final class ImmutableCollectionStream<T> {
        ImmutableCollectionStream() {
        }

        Stream<T> before(ImmutableCollection<T> collection) {
            return collection.asList().stream();
        }

        Stream<T> after(ImmutableCollection<T> collection) {
            return collection.stream();
        }
    }

    static final class ImmutableCollectionAsList<T> {
        ImmutableCollectionAsList() {
        }

        ImmutableList<T> before(ImmutableCollection<T> collection) {
            return ImmutableList.copyOf(collection);
        }

        ImmutableList<T> after(ImmutableCollection<T> collection) {
            return collection.asList();
        }
    }

    static final class NewArrayListFromCollection<T> {
        NewArrayListFromCollection() {
        }

        ArrayList<T> before(Collection<T> collection) {
            return Lists.newArrayList(collection);
        }

        ArrayList<T> after(Collection<T> collection) {
            return new ArrayList<T>(collection);
        }
    }

    static final class SetRemoveAllCollection<T, S extends T> {
        SetRemoveAllCollection() {
        }

        void before(Set<T> removeFrom, Collection<S> elementsToRemove) {
            elementsToRemove.forEach(removeFrom::remove);
        }

        void before2(Set<T> removeFrom, Collection<S> elementsToRemove) {
            for (S element : elementsToRemove) {
                removeFrom.remove(element);
            }
        }

        void before3(Set<T> removeFrom, Collection<S> elementsToRemove) {
            for (S element : elementsToRemove) {
                removeFrom.remove(element);
            }
        }

        void after(Set<T> removeFrom, Collection<S> elementsToRemove) {
            removeFrom.removeAll(elementsToRemove);
        }
    }

    static final class CollectionRemoveAllFromCollectionExpression<T, S extends T> {
        CollectionRemoveAllFromCollectionExpression() {
        }

        boolean before(Collection<T> removeTo, Collection<S> elementsToRemove) {
            return Iterables.removeAll(removeTo, elementsToRemove);
        }

        boolean after(Collection<T> removeTo, Collection<S> elementsToRemove) {
            return removeTo.removeAll(elementsToRemove);
        }
    }

    static final class CollectionAddAllToCollectionBlock<T, S extends T> {
        CollectionAddAllToCollectionBlock() {
        }

        void before(Collection<T> addTo, Collection<S> elementsToAdd) {
            elementsToAdd.forEach(addTo::add);
        }

        void before2(Collection<T> addTo, Collection<S> elementsToAdd) {
            for (S element : elementsToAdd) {
                addTo.add(element);
            }
        }

        void before3(Collection<T> addTo, Collection<S> elementsToAdd) {
            for (S element : elementsToAdd) {
                addTo.add(element);
            }
        }

        void after(Collection<T> addTo, Collection<S> elementsToAdd) {
            addTo.addAll(elementsToAdd);
        }
    }

    static final class CollectionAddAllToCollectionExpression<T, S extends T> {
        CollectionAddAllToCollectionExpression() {
        }

        boolean before(Collection<T> addTo, Collection<S> elementsToAdd) {
            return Iterables.addAll(addTo, elementsToAdd);
        }

        boolean after(Collection<T> addTo, Collection<S> elementsToAdd) {
            return addTo.addAll(elementsToAdd);
        }
    }

    static final class CollectionContains<T, S> {
        CollectionContains() {
        }

        boolean before(Collection<T> collection, S value) {
            return collection.stream().anyMatch(value::equals);
        }

        boolean after(Collection<T> collection, S value) {
            return collection.contains(value);
        }
    }

    static final class CollectionSize<T> {
        CollectionSize() {
        }

        int before(Collection<T> collection) {
            return Iterables.size(collection);
        }

        int before(ImmutableCollection<T> collection) {
            return collection.asList().size();
        }

        int after(Collection<T> collection) {
            return collection.size();
        }
    }

    static final class CollectionIsEmpty<T> {
        CollectionIsEmpty() {
        }

        boolean before(Collection<T> collection) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{collection.size() == 0, collection.size() <= 0, collection.size() < 1, Iterables.isEmpty(collection)});
        }

        boolean before(ImmutableCollection<T> collection) {
            return collection.asList().isEmpty();
        }

        boolean after(Collection<T> collection) {
            return collection.isEmpty();
        }
    }
}

