/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.errorprone.fixes.SuggestedFix;
import com.sun.source.tree.Tree;

final class SuggestedFixRules {
    private SuggestedFixRules() {
    }

    static final class SuggestedFixPostfixWith {
        SuggestedFixPostfixWith() {
        }

        SuggestedFix before(Tree tree, String postfix) {
            return SuggestedFix.builder().postfixWith(tree, postfix).build();
        }

        SuggestedFix after(Tree tree, String postfix) {
            return SuggestedFix.postfixWith((Tree)tree, (String)postfix);
        }
    }

    static final class SuggestedFixPrefixWith {
        SuggestedFixPrefixWith() {
        }

        SuggestedFix before(Tree tree, String prefix) {
            return SuggestedFix.builder().prefixWith(tree, prefix).build();
        }

        SuggestedFix after(Tree tree, String prefix) {
            return SuggestedFix.prefixWith((Tree)tree, (String)prefix);
        }
    }

    static final class SuggestedFixSwap {
        SuggestedFixSwap() {
        }

        SuggestedFix before(Tree tree1, Tree tree2) {
            return SuggestedFix.builder().swap(tree1, tree2).build();
        }

        SuggestedFix after(Tree tree1, Tree tree2) {
            return SuggestedFix.swap((Tree)tree1, (Tree)tree2);
        }
    }

    static final class SuggestedFixReplaceTreeStartEnd {
        SuggestedFixReplaceTreeStartEnd() {
        }

        SuggestedFix before(Tree tree, String replaceWith, int start, int end) {
            return SuggestedFix.builder().replace(tree, replaceWith, start, end).build();
        }

        SuggestedFix after(Tree tree, String replaceWith, int start, int end) {
            return SuggestedFix.replace((Tree)tree, (String)replaceWith, (int)start, (int)end);
        }
    }

    static final class SuggestedFixReplaceStartEnd {
        SuggestedFixReplaceStartEnd() {
        }

        SuggestedFix before(int start, int end, String replaceWith) {
            return SuggestedFix.builder().replace(start, end, replaceWith).build();
        }

        SuggestedFix after(int start, int end, String replaceWith) {
            return SuggestedFix.replace((int)start, (int)end, (String)replaceWith);
        }
    }

    static final class SuggestedFixReplaceTree {
        SuggestedFixReplaceTree() {
        }

        SuggestedFix before(Tree tree, String replaceWith) {
            return SuggestedFix.builder().replace(tree, replaceWith).build();
        }

        SuggestedFix after(Tree tree, String replaceWith) {
            return SuggestedFix.replace((Tree)tree, (String)replaceWith);
        }
    }

    static final class SuggestedFixDelete {
        SuggestedFixDelete() {
        }

        SuggestedFix before(Tree tree) {
            return SuggestedFix.builder().delete(tree).build();
        }

        SuggestedFix after(Tree tree) {
            return SuggestedFix.delete((Tree)tree);
        }
    }
}

