/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.base.Utf8;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

final class StringRules {
    private StringRules() {
    }

    static final class Utf8EncodedLength {
        Utf8EncodedLength() {
        }

        int before(String str) {
            return str.getBytes(StandardCharsets.UTF_8).length;
        }

        int after(String str) {
            return Utf8.encodedLength((CharSequence)str);
        }
    }

    static final class SubstringRemainder {
        SubstringRemainder() {
        }

        String before(String str, int index) {
            return str.substring(index, str.length());
        }

        String after(String str, int index) {
            return str.substring(index);
        }
    }

    static final class StringValueOfMethodReference {
        StringValueOfMethodReference() {
        }

        Function<Object, String> before() {
            return Objects::toString;
        }

        Function<Object, String> after() {
            return String::valueOf;
        }
    }

    static final class StringValueOf {
        StringValueOf() {
        }

        String before(Object object) {
            return Objects.toString(object);
        }

        String after(Object object) {
            return String.valueOf(object);
        }
    }

    static final class JoinStrings {
        JoinStrings() {
        }

        String before(String delimiter, CharSequence[] elements) {
            return (String)Refaster.anyOf((Object[])new String[]{Joiner.on((String)delimiter).join((Object[])elements), Arrays.stream(elements).collect(Collectors.joining(delimiter))});
        }

        String before(String delimiter, Iterable<? extends CharSequence> elements) {
            return (String)Refaster.anyOf((Object[])new String[]{Joiner.on((String)delimiter).join(elements), Streams.stream(elements).collect(Collectors.joining(delimiter))});
        }

        String before(CharSequence delimiter, Collection<? extends CharSequence> elements) {
            return elements.stream().collect(Collectors.joining(delimiter));
        }

        String after(CharSequence delimiter, Iterable<? extends CharSequence> elements) {
            return String.join(delimiter, elements);
        }
    }

    static final class FilterEmptyString {
        FilterEmptyString() {
        }

        Optional<String> before(Optional<String> optional) {
            return optional.map(Strings::emptyToNull);
        }

        Optional<String> after(Optional<String> optional) {
            return optional.filter(Predicate.not(String::isEmpty));
        }
    }

    static final class OptionalNonEmptyString {
        OptionalNonEmptyString() {
        }

        Optional<String> before(String str) {
            return Strings.isNullOrEmpty((String)str) ? Optional.empty() : (Optional)Refaster.anyOf((Object[])new Optional[]{Optional.of(str), Optional.ofNullable(str)});
        }

        Optional<String> after(String str) {
            return Optional.ofNullable(str).filter(Predicate.not(String::isEmpty));
        }
    }

    static final class StringIsNullOrEmpty {
        StringIsNullOrEmpty() {
        }

        boolean before(@Nullable String str) {
            return str == null || str.isEmpty();
        }

        boolean after(String str) {
            return Strings.isNullOrEmpty((String)str);
        }
    }

    static final class StringIsNotEmptyPredicate {
        StringIsNotEmptyPredicate() {
        }

        Predicate<String> before() {
            return s -> !s.isEmpty();
        }

        Predicate<String> after() {
            return Predicate.not(String::isEmpty);
        }
    }

    static final class StringIsEmptyPredicate {
        StringIsEmptyPredicate() {
        }

        Predicate<String> before() {
            return s -> s.isEmpty();
        }

        Predicate<String> after() {
            return String::isEmpty;
        }
    }

    static final class StringIsEmpty {
        StringIsEmpty() {
        }

        boolean before(String str) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{str.length() == 0, str.length() <= 0, str.length() < 1});
        }

        boolean after(String str) {
            return str.isEmpty();
        }
    }
}

