/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MethodMatcherFactory {
    private static final Splitter ARGUMENT_TYPE_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private static final Pattern METHOD_SIGNATURE = Pattern.compile("([^\\s#(,)]+)#([^\\s#(,)]+)\\(((?:[^\\s#(,)]+(?:,[^\\s#(,)]+)*)?)\\)");

    public com.google.errorprone.matchers.Matcher<ExpressionTree> create(Collection<String> signatures) {
        return Matchers.anyOf((Iterable)((Iterable)signatures.stream().map(MethodMatcherFactory::createMethodMatcher).collect(ImmutableSet.toImmutableSet())));
    }

    private static com.google.errorprone.matchers.Matcher<ExpressionTree> createMethodMatcher(CharSequence signature) {
        Matcher m = METHOD_SIGNATURE.matcher(signature);
        Preconditions.checkArgument((boolean)m.matches(), (String)"Not a valid method signature: %s", (Object)signature);
        String className = m.group(1);
        String methodName = m.group(2);
        Iterable parameterTypes = ARGUMENT_TYPE_SPLITTER.split((CharSequence)m.group(3));
        return Matchers.anyOf((com.google.errorprone.matchers.Matcher[])new com.google.errorprone.matchers.Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(className).named(methodName).withParameters(parameterTypes), MethodMatchers.staticMethod().onClass(className).named(methodName).withParameters(parameterTypes)});
    }
}

