/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.util.Context;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Specify a `Locale` when calling `String#to{Lower,Upper}Case`", link="https://error-prone.picnic.tech/bugpatterns/StringCaseLocaleUsage", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
@AutoService(value={BugChecker.class})
public final class StringCaseLocaleUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> DEFAULT_LOCALE_CASE_CONVERSION = MethodMatchers.instanceMethod().onExactClass(String.class.getName()).namedAnyOf(new String[]{"toLowerCase", "toUpperCase"}).withNoParameters();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!DEFAULT_LOCALE_CASE_CONVERSION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        int closingParenPosition = StringCaseLocaleUsage.getClosingParenPosition(tree, state);
        if (closingParenPosition == -1) {
            return this.describeMatch(tree);
        }
        return this.buildDescription(tree).addFix(StringCaseLocaleUsage.suggestLocale(closingParenPosition, "Locale.ROOT")).addFix(StringCaseLocaleUsage.suggestLocale(closingParenPosition, "Locale.getDefault()")).build();
    }

    private static Fix suggestLocale(int insertPosition, String locale) {
        return SuggestedFix.builder().addImport("java.util.Locale").replace(insertPosition, insertPosition, locale).build();
    }

    private static int getClosingParenPosition(MethodInvocationTree tree, VisitorState state) {
        int startPosition = ASTHelpers.getStartPosition((Tree)tree);
        if (startPosition == -1) {
            return -1;
        }
        return Streams.findLast(ErrorProneTokens.getTokens((String)SourceCode.treeToString(tree, state), (Context)state.context).stream().filter(t -> t.kind() == Tokens.TokenKind.RPAREN)).map(token -> startPosition + token.pos()).orElse(-1);
    }
}

