/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.errorprone.refaster.Refaster;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

final class TimeTemplates {
    private TimeTemplates() {
    }

    static final class ZeroPeriod {
        ZeroPeriod() {
        }

        Period before() {
            return (Period)Refaster.anyOf((Object[])new Period[]{Period.ofDays(0), Period.ofWeeks(0), Period.ofMonths(0), Period.ofYears(0), Period.of(0, 0, 0)});
        }

        Period after() {
            return Period.ZERO;
        }
    }

    static final class DurationIsZero {
        DurationIsZero() {
        }

        boolean before(Duration duration) {
            return (Boolean)Refaster.anyOf((Object[])new Boolean[]{duration.equals(Duration.ZERO), Duration.ZERO.equals(duration)});
        }

        boolean after(Duration duration) {
            return duration.isZero();
        }
    }

    static final class DurationBetweenOffsetDateTimes {
        DurationBetweenOffsetDateTimes() {
        }

        Duration before(OffsetDateTime a, OffsetDateTime b) {
            return (Duration)Refaster.anyOf((Object[])new Duration[]{Duration.between(a.toInstant(), b.toInstant()), Duration.ofSeconds(b.toEpochSecond() - a.toEpochSecond())});
        }

        Duration after(OffsetDateTime a, OffsetDateTime b) {
            return Duration.between(a, b);
        }
    }

    static final class DurationBetweenInstants {
        DurationBetweenInstants() {
        }

        Duration before(Instant a, Instant b) {
            return Duration.ofMillis(b.toEpochMilli() - a.toEpochMilli());
        }

        Duration after(Instant a, Instant b) {
            return Duration.between(a, b);
        }
    }

    static final class DurationOfSeconds {
        DurationOfSeconds() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.SECONDS);
        }

        Duration after(long amount) {
            return Duration.ofSeconds(amount);
        }
    }

    static final class DurationOfNanos {
        DurationOfNanos() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.NANOS);
        }

        Duration after(long amount) {
            return Duration.ofNanos(amount);
        }
    }

    static final class DurationOfMinutes {
        DurationOfMinutes() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.MINUTES);
        }

        Duration after(long amount) {
            return Duration.ofMinutes(amount);
        }
    }

    static final class DurationOfMillis {
        DurationOfMillis() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.MILLIS);
        }

        Duration after(long amount) {
            return Duration.ofMillis(amount);
        }
    }

    static final class DurationOfHours {
        DurationOfHours() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.HOURS);
        }

        Duration after(long amount) {
            return Duration.ofHours(amount);
        }
    }

    static final class DurationOfDays {
        DurationOfDays() {
        }

        Duration before(long amount) {
            return Duration.of(amount, ChronoUnit.DAYS);
        }

        Duration after(long amount) {
            return Duration.ofDays(amount);
        }
    }

    static final class ZeroDuration {
        ZeroDuration() {
        }

        Duration before(TemporalUnit temporalUnit) {
            return (Duration)Refaster.anyOf((Object[])new Duration[]{Duration.ofNanos(0L), Duration.ofMillis(0L), Duration.ofSeconds(0L), Duration.ofSeconds(0L, 0L), Duration.ofMinutes(0L), Duration.ofHours(0L), Duration.ofDays(0L), Duration.of(0L, temporalUnit)});
        }

        Duration after() {
            return Duration.ZERO;
        }
    }

    static final class OffsetDateTimeIsAfter {
        OffsetDateTimeIsAfter() {
        }

        boolean before(OffsetDateTime a, OffsetDateTime b) {
            return a.compareTo(b) > 0;
        }

        boolean after(OffsetDateTime a, OffsetDateTime b) {
            return a.isAfter(b);
        }
    }

    static final class OffsetDateTimeIsBefore {
        OffsetDateTimeIsBefore() {
        }

        boolean before(OffsetDateTime a, OffsetDateTime b) {
            return a.compareTo(b) < 0;
        }

        boolean after(OffsetDateTime a, OffsetDateTime b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoZonedDateTimeIsAfter {
        ChronoZonedDateTimeIsAfter() {
        }

        boolean before(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoZonedDateTimeIsBefore {
        ChronoZonedDateTimeIsBefore() {
        }

        boolean before(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoZonedDateTime<?> a, ChronoZonedDateTime<?> b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoLocalDateTimeIsAfter {
        ChronoLocalDateTimeIsAfter() {
        }

        boolean before(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoLocalDateTimeIsBefore {
        ChronoLocalDateTimeIsBefore() {
        }

        boolean before(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoLocalDateTime<?> a, ChronoLocalDateTime<?> b) {
            return a.isBefore(b);
        }
    }

    static final class ChronoLocalDateIsAfter {
        ChronoLocalDateIsAfter() {
        }

        boolean before(ChronoLocalDate a, ChronoLocalDate b) {
            return a.compareTo(b) > 0;
        }

        boolean after(ChronoLocalDate a, ChronoLocalDate b) {
            return a.isAfter(b);
        }
    }

    static final class ChronoLocalDateIsBefore {
        ChronoLocalDateIsBefore() {
        }

        boolean before(ChronoLocalDate a, ChronoLocalDate b) {
            return a.compareTo(b) < 0;
        }

        boolean after(ChronoLocalDate a, ChronoLocalDate b) {
            return a.isBefore(b);
        }
    }

    static final class LocalDateAtStartOfDay {
        LocalDateAtStartOfDay() {
        }

        LocalDateTime before(LocalDate localDate) {
            return localDate.atTime(LocalTime.MIN);
        }

        LocalDateTime after(LocalDate localDate) {
            return localDate.atStartOfDay();
        }
    }

    static final class LocalTimeMin {
        LocalTimeMin() {
        }

        LocalTime before() {
            return (LocalTime)Refaster.anyOf((Object[])new LocalTime[]{LocalTime.MIDNIGHT, LocalTime.of(0, 0), LocalTime.of(0, 0, 0), LocalTime.of(0, 0, 0, 0), LocalTime.ofNanoOfDay(0L), LocalTime.ofSecondOfDay(0L)});
        }

        LocalTime after() {
            return LocalTime.MIN;
        }
    }

    static final class InstantIsAfter {
        InstantIsAfter() {
        }

        boolean before(Instant a, Instant b) {
            return a.compareTo(b) > 0;
        }

        boolean after(Instant a, Instant b) {
            return a.isAfter(b);
        }
    }

    static final class InstantIsBefore {
        InstantIsBefore() {
        }

        boolean before(Instant a, Instant b) {
            return a.compareTo(b) < 0;
        }

        boolean after(Instant a, Instant b) {
            return a.isBefore(b);
        }
    }

    static final class EpochInstant {
        EpochInstant() {
        }

        Instant before() {
            return (Instant)Refaster.anyOf((Object[])new Instant[]{Instant.ofEpochMilli(0L), Instant.ofEpochSecond(0L), Instant.ofEpochSecond(0L, 0L)});
        }

        Instant after() {
            return Instant.EPOCH;
        }
    }

    static final class UtcClock {
        UtcClock() {
        }

        Clock before() {
            return Clock.system(ZoneOffset.UTC);
        }

        Clock after() {
            return Clock.systemUTC();
        }
    }

    static final class InstantAtOffset {
        InstantAtOffset() {
        }

        OffsetDateTime before(Instant instant, ZoneOffset zoneOffset) {
            return OffsetDateTime.ofInstant(instant, zoneOffset);
        }

        OffsetDateTime after(Instant instant, ZoneOffset zoneOffset) {
            return instant.atOffset(zoneOffset);
        }
    }

    static final class UtcConstant {
        UtcConstant() {
        }

        ZoneId before() {
            return (ZoneId)Refaster.anyOf((Object[])new ZoneId[]{ZoneId.of("GMT"), ZoneId.of("UTC"), ZoneId.of("+0"), ZoneId.of("-0"), ZoneOffset.UTC.normalized(), ZoneId.from(ZoneOffset.UTC)});
        }

        ZoneOffset after() {
            return ZoneOffset.UTC;
        }
    }

    static final class ClockInstant {
        ClockInstant() {
        }

        Instant before(Clock clock) {
            return Instant.now(clock);
        }

        Instant after(Clock clock) {
            return clock.instant();
        }
    }
}

