/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refastertemplates;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Streams;
import com.google.errorprone.refaster.Refaster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.stream.Stream;

final class ImmutableSortedSetTemplates {
    private ImmutableSortedSetTemplates() {
    }

    static final class StreamToImmutableSortedSet<T extends Comparable<? super T>> {
        StreamToImmutableSortedSet() {
        }

        ImmutableSortedSet<T> before(Stream<T> stream) {
            return ImmutableSortedSet.copyOf(stream.iterator());
        }

        ImmutableSortedSet<T> after(Stream<T> stream) {
            return (ImmutableSortedSet)stream.collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
        }
    }

    static final class IterableToImmutableSortedSet<T extends Comparable<? super T>> {
        IterableToImmutableSortedSet() {
        }

        ImmutableSortedSet<T> before(T[] iterable) {
            return (ImmutableSortedSet)Refaster.anyOf((Object[])new ImmutableSortedSet[]{ImmutableSortedSet.naturalOrder().add((Object[])iterable).build(), (ImmutableSortedSet)Arrays.stream(iterable).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()))});
        }

        ImmutableSortedSet<T> before(Iterator<T> iterable) {
            return (ImmutableSortedSet)Refaster.anyOf((Object[])new ImmutableSortedSet[]{ImmutableSortedSet.copyOf(Comparator.naturalOrder(), iterable), ImmutableSortedSet.naturalOrder().addAll(iterable).build(), (ImmutableSortedSet)Streams.stream(iterable).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()))});
        }

        ImmutableSortedSet<T> before(Iterable<T> iterable) {
            return (ImmutableSortedSet)Refaster.anyOf((Object[])new ImmutableSortedSet[]{ImmutableSortedSet.copyOf(Comparator.naturalOrder(), iterable), ImmutableSortedSet.naturalOrder().addAll(iterable).build(), (ImmutableSortedSet)Streams.stream(iterable).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()))});
        }

        ImmutableSortedSet<T> before(Collection<T> iterable) {
            return (ImmutableSortedSet)iterable.stream().collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
        }

        ImmutableSortedSet<T> after(Iterable<T> iterable) {
            return ImmutableSortedSet.copyOf(iterable);
        }
    }

    static final class EmptyImmutableSortedSet<T extends Comparable<? super T>> {
        EmptyImmutableSortedSet() {
        }

        ImmutableSortedSet<T> before() {
            return (ImmutableSortedSet)Refaster.anyOf((Object[])new ImmutableSortedSet[]{ImmutableSortedSet.naturalOrder().build(), (ImmutableSortedSet)Stream.empty().collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()))});
        }

        ImmutableSortedSet<T> after() {
            return ImmutableSortedSet.of();
        }
    }

    static final class ImmutableSortedSetReverseOrderBuilder<T extends Comparable<? super T>> {
        ImmutableSortedSetReverseOrderBuilder() {
        }

        ImmutableSortedSet.Builder<T> before() {
            return ImmutableSortedSet.orderedBy(Comparator.reverseOrder());
        }

        ImmutableSortedSet.Builder<T> after() {
            return ImmutableSortedSet.reverseOrder();
        }
    }

    static final class ImmutableSortedSetNaturalOrderBuilder<T extends Comparable<? super T>> {
        ImmutableSortedSetNaturalOrderBuilder() {
        }

        ImmutableSortedSet.Builder<T> before() {
            return ImmutableSortedSet.orderedBy(Comparator.naturalOrder());
        }

        ImmutableSortedSet.Builder<T> after() {
            return ImmutableSortedSet.naturalOrder();
        }
    }

    static final class ImmutableSortedSetBuilder<T> {
        ImmutableSortedSetBuilder() {
        }

        ImmutableSortedSet.Builder<T> before(Comparator<T> cmp) {
            return new ImmutableSortedSet.Builder(cmp);
        }

        ImmutableSortedSet.Builder<T> after(Comparator<T> cmp) {
            return ImmutableSortedSet.orderedBy(cmp);
        }
    }
}

