/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import tech.picnic.errorprone.bugpatterns.util.SourceCode;

@BugPattern(summary="Don't unnecessarily use Mockito's `eq(...)`", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class MockitoStubbing
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> MOCKITO_EQ_METHOD = Matchers.staticMethod().onClass("org.mockito.ArgumentMatchers").named("eq");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.isEmpty() || !arguments.stream().allMatch(arg -> MockitoStubbing.isEqInvocation(arg, state))) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder suggestedFix = SuggestedFix.builder();
        for (ExpressionTree expressionTree : arguments) {
            suggestedFix.replace((Tree)expressionTree, SourceCode.treeToString((Tree)Iterables.getOnlyElement(((MethodInvocationTree)expressionTree).getArguments()), state));
        }
        return this.describeMatch(tree, (Fix)suggestedFix.build());
    }

    private static boolean isEqInvocation(ExpressionTree tree, VisitorState state) {
        return tree instanceof MethodInvocationTree && MOCKITO_EQ_METHOD.matches((Tree)tree, state);
    }
}

