/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.bugpatterns;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Prefer `.isNull()` over `.isEqualTo(null)`", linkType=BugPattern.LinkType.NONE, severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Simplification"})
@AutoService(value={BugChecker.class})
public final class AssertJIsNull
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<MethodInvocationTree> ASSERT_IS_EQUAL_TO_NULL = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("org.assertj.core.api.Assert").named("isEqualTo"), Matchers.argumentCount((int)1), Matchers.argument((int)0, (Matcher)Matchers.nullLiteral())});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ASSERT_IS_EQUAL_TO_NULL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder().merge(SuggestedFixes.renameMethodInvocation((MethodInvocationTree)tree, (String)"isNull", (VisitorState)state));
        tree.getArguments().forEach(arg -> fix.merge(SuggestedFix.delete((Tree)arg)));
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

