/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sun.source.util.JavacTask;
import com.sun.source.util.Plugin;
import com.sun.tools.javac.api.BasicJavacTask;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tech.picnic.errorprone.documentation.DocumentationGeneratorTaskListener;

@AutoService(value={Plugin.class})
public final class DocumentationGenerator
implements Plugin {
    @VisibleForTesting
    static final String OUTPUT_DIRECTORY_FLAG = "-XoutputDirectory";
    private static final Pattern OUTPUT_DIRECTORY_FLAG_PATTERN = Pattern.compile(Pattern.quote("-XoutputDirectory") + "=(.*)");

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void init(JavacTask javacTask, String ... args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Precisely one path must be provided");
        javacTask.addTaskListener(new DocumentationGeneratorTaskListener(((BasicJavacTask)javacTask).getContext(), DocumentationGenerator.getOutputPath(args[0])));
    }

    @VisibleForTesting
    static Path getOutputPath(String pathArg) {
        Matcher matcher = OUTPUT_DIRECTORY_FLAG_PATTERN.matcher(pathArg);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"'%s' must be of the form '%s=<value>'", (Object)pathArg, (Object)OUTPUT_DIRECTORY_FLAG);
        String path = matcher.group(1);
        try {
            return Path.of(path, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new IllegalArgumentException("Invalid path '%s'".formatted(path), e);
        }
    }
}

