/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.VisitorState;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ServiceLoader;
import javax.tools.JavaFileObject;
import tech.picnic.errorprone.documentation.Extractor;
import tech.picnic.errorprone.documentation.Json;

final class DocumentationGeneratorTaskListener
implements TaskListener {
    private static final ImmutableList<Extractor<?>> EXTRACTORS = ImmutableList.copyOf(ServiceLoader.load(Extractor.class, DocumentationGeneratorTaskListener.class.getClassLoader()));
    private final Context context;
    private final Path docsPath;

    DocumentationGeneratorTaskListener(Context context, Path path) {
        this.context = context;
        this.docsPath = path;
    }

    @Override
    public void started(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
            this.createDocsDirectory();
        }
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        JavaFileObject sourceFile = taskEvent.getSourceFile();
        CompilationUnitTree compilationUnit = taskEvent.getCompilationUnit();
        JCTree.JCClassDecl classTree = JavacTrees.instance(this.context).getTree(taskEvent.getTypeElement());
        if (sourceFile == null || compilationUnit == null || classTree == null) {
            return;
        }
        VisitorState state = VisitorState.createForUtilityPurposes((Context)this.context).withPath(new TreePath(new TreePath(compilationUnit), classTree));
        for (Extractor extractor : EXTRACTORS) {
            extractor.tryExtract(classTree, state).ifPresent(data -> this.writeToFile(extractor.identifier(), DocumentationGeneratorTaskListener.getSimpleClassName(sourceFile.toUri()), data));
        }
    }

    private void createDocsDirectory() {
        try {
            Files.createDirectories(this.docsPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error while creating directory with path '%s'", this.docsPath), e);
        }
    }

    private <T> void writeToFile(String identifier, String className, T data) {
        Json.write(this.docsPath.resolve(String.format("%s-%s.json", identifier, className)), data);
    }

    private static String getSimpleClassName(URI path) {
        return Path.of(path).getFileName().toString().replace(".java", "");
    }
}

