/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sun.source.tree.ClassTree;
import java.util.EnumSet;
import java.util.Optional;
import tech.picnic.errorprone.documentation.BugPatternExtractor;
import tech.picnic.errorprone.documentation.Extractor;

enum ExtractorType {
    BUG_PATTERN("bugpattern", new BugPatternExtractor());

    private static final ImmutableSet<ExtractorType> TYPES;
    private final String identifier;
    private final Extractor<?> extractor;

    private ExtractorType(String identifier, Extractor<?> extractor) {
        this.identifier = identifier;
        this.extractor = extractor;
    }

    String getIdentifier() {
        return this.identifier;
    }

    Extractor<?> getExtractor() {
        return this.extractor;
    }

    static Optional<ExtractorType> findMatchingType(ClassTree tree) {
        return TYPES.stream().filter(type -> type.getExtractor().canExtract(tree)).findFirst();
    }

    static {
        TYPES = Sets.immutableEnumSet(EnumSet.allOf(ExtractorType.class));
    }
}

