/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.tools.JavaFileObject;
import tech.picnic.errorprone.documentation.ExtractorType;

final class DocumentationGeneratorTaskListener
implements TaskListener {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    private final Context context;
    private final Path docsPath;

    DocumentationGeneratorTaskListener(Context context, Path path) {
        this.context = context;
        this.docsPath = path;
    }

    @Override
    public void started(TaskEvent taskEvent) {
        if (taskEvent.getKind() == TaskEvent.Kind.ANALYZE) {
            this.createDocsDirectory();
        }
    }

    @Override
    public void finished(TaskEvent taskEvent) {
        if (taskEvent.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        JCTree.JCClassDecl classTree = JavacTrees.instance(this.context).getTree(taskEvent.getTypeElement());
        JavaFileObject sourceFile = taskEvent.getSourceFile();
        if (classTree == null || sourceFile == null) {
            return;
        }
        ExtractorType.findMatchingType(classTree).ifPresent(extractorType -> this.writeToFile(extractorType.getIdentifier(), DocumentationGeneratorTaskListener.getSimpleClassName(sourceFile.toUri()), extractorType.getExtractor().extract(classTree, this.context)));
    }

    private void createDocsDirectory() {
        try {
            Files.createDirectories(this.docsPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Error while creating directory with path '%s'", this.docsPath), e);
        }
    }

    private <T> void writeToFile(String identifier, String className, T data) {
        File file = this.docsPath.resolve(String.format("%s-%s.json", identifier, className)).toFile();
        try (FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8);){
            OBJECT_MAPPER.writeValue((Writer)fileWriter, data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Cannot write to file '%s'", file.getPath()), e);
        }
    }

    private static String getSimpleClassName(URI path) {
        return Paths.get(path).getFileName().toString().replace(".java", "");
    }
}

