/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.documentation;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.value.AutoValue;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.List;
import java.util.Objects;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import tech.picnic.errorprone.documentation.AutoValue_BugPatternExtractor_BugPatternDocumentation;
import tech.picnic.errorprone.documentation.Extractor;

@Immutable
final class BugPatternExtractor
implements Extractor<BugPatternDocumentation> {
    BugPatternExtractor() {
    }

    @Override
    public BugPatternDocumentation extract(ClassTree tree, Context context) {
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        BugPattern annotation = symbol.getAnnotation(BugPattern.class);
        Objects.requireNonNull(annotation, "BugPattern annotation must be present");
        return new AutoValue_BugPatternExtractor_BugPatternDocumentation(symbol.getQualifiedName().toString(), annotation.name().isEmpty() ? tree.getSimpleName().toString() : annotation.name(), (ImmutableList<String>)ImmutableList.copyOf((Object[])annotation.altNames()), annotation.link(), (ImmutableList<String>)ImmutableList.copyOf((Object[])annotation.tags()), annotation.summary(), annotation.explanation(), annotation.severity(), annotation.disableable(), annotation.documentSuppression() ? BugPatternExtractor.getSuppressionAnnotations(tree) : ImmutableList.of());
    }

    @Override
    public boolean canExtract(ClassTree tree) {
        return ASTHelpers.hasDirectAnnotationWithSimpleName((Tree)tree, (String)BugPattern.class.getSimpleName());
    }

    private static ImmutableList<String> getSuppressionAnnotations(ClassTree tree) {
        AnnotationTree annotationTree = ASTHelpers.getAnnotationWithSimpleName((List)ASTHelpers.getAnnotations((Tree)tree), (String)BugPattern.class.getSimpleName());
        Objects.requireNonNull(annotationTree, "BugPattern annotation must be present");
        Attribute.Array types = BugPatternExtractor.doCast(AnnotationMirrors.getAnnotationValue((AnnotationMirror)ASTHelpers.getAnnotationMirror((AnnotationTree)annotationTree), (String)"suppressionAnnotations"), Attribute.Array.class);
        return (ImmutableList)types.getValue().stream().map(v -> BugPatternExtractor.doCast((AnnotationValue)v, Attribute.Class.class).classType.toString()).collect(ImmutableList.toImmutableList());
    }

    private static <T extends AnnotationValue> T doCast(AnnotationValue value, Class<T> target) {
        Verify.verify((boolean)target.isInstance(value), (String)"Value '%s' is not of type '%s'", (Object)value, target);
        return (T)value;
    }

    @AutoValue
    static abstract class BugPatternDocumentation {
        BugPatternDocumentation() {
        }

        abstract String fullyQualifiedName();

        abstract String name();

        abstract ImmutableList<String> altNames();

        abstract String link();

        abstract ImmutableList<String> tags();

        abstract String summary();

        abstract String explanation();

        abstract BugPattern.SeverityLevel severityLevel();

        abstract boolean canDisable();

        abstract ImmutableList<String> suppressionAnnotations();
    }
}

