/*
 * Decompiled with CFR 0.152.
 */
package tech.orla;

import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import tech.orla.AbstractOSProcess;
import tech.orla.api.Assets;
import tech.orla.api.GithubTrivyReleaseApi;
import tech.orla.api.Release;
import tech.orla.utils.OS;
import tech.orla.utils.OSDetector;

public class TrivyProcess
extends AbstractOSProcess {
    public static final Logger LOG = Logger.getLogger(TrivyProcess.class.getName());
    private final GithubTrivyReleaseApi githubTrivyReleaseApi;

    public TrivyProcess(GithubTrivyReleaseApi githubTrivyReleaseApi) {
        this.githubTrivyReleaseApi = githubTrivyReleaseApi;
    }

    public String resolveBinaryName(String tag) {
        OS os = OSDetector.getOS();
        String pattern = "trivy_%s_%s-%sbit.tar.gz";
        if (os.equals((Object)OS.UNIX)) {
            return String.format(pattern, tag.substring(1), "Linux", "64");
        }
        if (os.equals((Object)OS.WINDOWS)) {
            return String.format(pattern, tag.substring(1), "Windows", "64");
        }
        if (os.equals((Object)OS.MAC_OSX)) {
            return String.format(pattern, tag.substring(1), "macOS", "64");
        }
        return "";
    }

    public Path downloadBinaryFromGithubAssets(String downloadUrl, String file) {
        try {
            URL url = new URL(downloadUrl);
            InputStream inputStream = url.openStream();
            String targetDirectoryPath = Paths.get("", new String[0]).toAbsolutePath() + "/target";
            String targetFilePath = targetDirectoryPath + "/" + file;
            try (FileOutputStream outputStream = new FileOutputStream(targetFilePath);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
            }
            inputStream.close();
            return Path.of(targetFilePath, new String[0]);
        }
        catch (Exception e) {
            LOG.info("error download trivy binary. Error: ".concat(e.getMessage()));
            System.out.println("error download trivy binary".concat(e.getMessage()));
            throw new RuntimeException("error download binary trivy");
        }
    }

    /*
     * Exception decompiling
     */
    public Path decompressTarGz(Path pathFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getLocationTrivyBin(String trivyTag) throws Exception {
        File fileAlreadyExists = this.getBinFileIfAlreadyExists();
        if (fileAlreadyExists != null) {
            return fileAlreadyExists;
        }
        Release release = this.githubTrivyReleaseApi.releaseByTag(trivyTag);
        String resolveBinaryName = this.resolveBinaryName(trivyTag);
        Optional<Assets> donwloadURl = release.getAssets().stream().filter(asset -> asset.getName().equals(resolveBinaryName)).findFirst();
        LOG.info("Start download trivy binary from github. binary_name: ".concat(resolveBinaryName));
        Path pathFile = this.downloadBinaryFromGithubAssets(donwloadURl.get().getBrowserDownloadUrl(), resolveBinaryName);
        LOG.info("Download finished");
        LOG.info("Start decompress tar.gz");
        Path binFile = this.decompressTarGz(pathFile);
        LOG.info("Decompress finished");
        File fileBin = new File(binFile.toAbsolutePath().toString());
        fileBin.setExecutable(true);
        return fileBin;
    }

    private File getBinFileIfAlreadyExists() {
        String targetPath = Paths.get("", new String[0]).toAbsolutePath() + "/target/trivy";
        File binFile = new File(targetPath);
        if (binFile.exists()) {
            return binFile;
        }
        return null;
    }

    public File extractExecutableFromJar(String executable) throws IOException {
        File tmpDir = Files.createTempDir();
        tmpDir.deleteOnExit();
        File command = new File(tmpDir, executable);
        FileUtils.copyURLToFile((URL)Resources.getResource((String)executable), (File)command);
        command.deleteOnExit();
        command.setExecutable(true);
        return command;
    }

    public Integer scanImage(String dockerImageName, String trivyParams, String trivyTag) throws Exception {
        String command = "%s image --exit-code 1 %s %s";
        File bin = this.getLocationTrivyBin(trivyTag);
        String finalCommand = String.format(command, bin.getAbsolutePath(), trivyParams, dockerImageName);
        return TrivyProcess.execProcess(finalCommand, true);
    }
}

