/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import tagbio.umap.metric.Metric;

public final class CosineMetric
extends Metric {
    public static final CosineMetric SINGLETON = new CosineMetric();

    private CosineMetric() {
        super(true);
    }

    @Override
    public float distance(float[] x, float[] y) {
        double result = 0.0;
        double normX = 0.0;
        double normY = 0.0;
        for (int i = 0; i < x.length; ++i) {
            result += (double)(x[i] * y[i]);
            normX += (double)(x[i] * x[i]);
            normY += (double)(y[i] * y[i]);
        }
        if (normX == 0.0 && normY == 0.0) {
            return 0.0f;
        }
        if (normX == 0.0 || normY == 0.0) {
            return 1.0f;
        }
        return (float)(1.0 - result / Math.sqrt(normX * normY));
    }
}

