/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Random;
import tagbio.umap.MathUtils;
import tagbio.umap.Matrix;

final class Utils {
    private Utils() {
    }

    static String now() {
        StringBuilder sb = new StringBuilder();
        GregorianCalendar cal = new GregorianCalendar();
        sb.append(cal.get(1)).append('-');
        int month = 1 + cal.get(2);
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month).append('-');
        int date = cal.get(5);
        if (date < 10) {
            sb.append('0');
        }
        sb.append(date).append(' ');
        int hour = cal.get(11);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour).append(':');
        int min = cal.get(12);
        if (min < 10) {
            sb.append('0');
        }
        sb.append(min).append(':');
        int sec = cal.get(13);
        if (sec < 10) {
            sb.append('0');
        }
        sb.append(sec).append(' ');
        return sb.toString();
    }

    static void message(String message) {
        System.out.println(Utils.now() + message);
    }

    static int[][] fastKnnIndices(Matrix instances, int nNeighbors) {
        int[][] knnIndices = new int[instances.rows()][nNeighbors];
        for (int row = 0; row < instances.rows(); ++row) {
            int[] v = MathUtils.argsort(Arrays.copyOf(instances.row(row), instances.cols()));
            knnIndices[row] = Arrays.copyOf(v, nNeighbors);
        }
        return knnIndices;
    }

    static float norm(float[] vec) {
        float result = 0.0f;
        for (float v : vec) {
            result += v * v;
        }
        return (float)Math.sqrt(result);
    }

    static int[] rejectionSample(int nSamples, int poolSize, Random random) {
        if (nSamples > poolSize) {
            throw new IllegalArgumentException();
        }
        int[] result = new int[nSamples];
        for (int i = 0; i < result.length; ++i) {
            int j;
            boolean ok;
            block1: do {
                j = random.nextInt(poolSize);
                ok = true;
                for (int k = 0; k < i; ++k) {
                    if (j != result[k]) continue;
                    ok = false;
                    continue block1;
                }
            } while (!ok);
            result[i] = j;
        }
        return result;
    }

    static float[][] submatrix(Matrix matrix, int[][] indicesCol, int nNeighbors) {
        int nSamplesTransform = matrix.rows();
        float[][] submat = new float[nSamplesTransform][nNeighbors];
        for (int i = 0; i < nSamplesTransform; ++i) {
            for (int j = 0; j < nNeighbors; ++j) {
                submat[i][j] = matrix.get(i, indicesCol[i][j]);
            }
        }
        return submat;
    }

    static Random[] splitRandom(Random random, int n) {
        Random[] randoms = new Random[n];
        long baseSeed = random.nextLong();
        for (int j = 0; j < n; ++j) {
            randoms[j] = new Random(baseSeed * (long)(j + 1) + (long)j);
        }
        return randoms;
    }
}

