/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import tagbio.umap.Utils;

class SparseVector {
    private final int[] mIndices;
    private final float[] mData;

    SparseVector(int[] indices, float[] data) {
        if (data.length != indices.length) {
            throw new IllegalArgumentException();
        }
        this.mIndices = indices;
        this.mData = data;
    }

    int[] getIndices() {
        return this.mIndices;
    }

    float[] getData() {
        return this.mData;
    }

    float norm() {
        return Utils.norm(this.mData);
    }

    void divide(float v) {
        int k = 0;
        while (k < this.mData.length) {
            int n = k++;
            this.mData[n] = this.mData[n] / v;
        }
    }

    SparseVector add(SparseVector right) {
        int[] resultInd = new int[this.mIndices.length + right.mIndices.length];
        float[] resultData = new float[resultInd.length];
        int i1 = 0;
        int i2 = 0;
        int nnz = 0;
        while (i1 < this.mIndices.length && i2 < right.mIndices.length) {
            float val;
            int j1 = this.mIndices[i1];
            int j2 = right.mIndices[i2];
            if (j1 == j2) {
                if ((val = this.mData[i1++] + right.mData[i2++]) == 0.0f) continue;
                resultInd[nnz] = j1;
                resultData[nnz++] = val;
                continue;
            }
            if (j1 < j2) {
                if ((val = this.mData[i1++]) == 0.0f) continue;
                resultInd[nnz] = j1;
                resultData[nnz++] = val;
                continue;
            }
            if ((val = right.mData[i2++]) == 0.0f) continue;
            resultInd[nnz] = j2;
            resultData[nnz++] = val;
        }
        while (i1 < this.mIndices.length) {
            float val = this.mData[i1];
            if (val != 0.0f) {
                resultInd[nnz] = this.mIndices[i1];
                resultData[nnz++] = val;
            }
            ++i1;
        }
        while (i2 < right.mIndices.length) {
            float val = right.mData[i2];
            if (val != 0.0f) {
                resultInd[nnz] = right.mIndices[i2];
                resultData[nnz++] = val;
            }
            ++i2;
        }
        if (nnz == resultInd.length) {
            return new SparseVector(resultInd, resultData);
        }
        return new SparseVector(Arrays.copyOf(resultInd, nnz), Arrays.copyOf(resultData, nnz));
    }

    SparseVector subtract(SparseVector right) {
        int[] resultInd = new int[this.mIndices.length + right.mIndices.length];
        float[] resultData = new float[resultInd.length];
        int i1 = 0;
        int i2 = 0;
        int nnz = 0;
        while (i1 < this.mIndices.length && i2 < right.mIndices.length) {
            float val;
            int j1 = this.mIndices[i1];
            int j2 = right.mIndices[i2];
            if (j1 == j2) {
                if ((val = this.mData[i1++] - right.mData[i2++]) == 0.0f) continue;
                resultInd[nnz] = j1;
                resultData[nnz++] = val;
                continue;
            }
            if (j1 < j2) {
                if ((val = this.mData[i1++]) == 0.0f) continue;
                resultInd[nnz] = j1;
                resultData[nnz++] = val;
                continue;
            }
            if ((val = right.mData[i2++]) == 0.0f) continue;
            resultInd[nnz] = j2;
            resultData[nnz++] = -val;
        }
        while (i1 < this.mIndices.length) {
            float val = this.mData[i1];
            if (val != 0.0f) {
                resultInd[nnz] = this.mIndices[i1];
                resultData[nnz++] = val;
            }
            ++i1;
        }
        while (i2 < right.mIndices.length) {
            float val = right.mData[i2];
            if (val != 0.0f) {
                resultInd[nnz] = right.mIndices[i2];
                resultData[nnz++] = -val;
            }
            ++i2;
        }
        if (nnz == resultInd.length) {
            return new SparseVector(resultInd, resultData);
        }
        return new SparseVector(Arrays.copyOf(resultInd, nnz), Arrays.copyOf(resultData, nnz));
    }

    SparseVector hadamardMultiply(SparseVector right) {
        int[] resultInd = new int[Math.min(this.mIndices.length, right.mIndices.length)];
        float[] resultData = new float[resultInd.length];
        int i1 = 0;
        int i2 = 0;
        int nnz = 0;
        while (i1 < this.mIndices.length && i2 < right.mIndices.length) {
            int j1 = this.mIndices[i1];
            int j2 = right.mIndices[i2];
            if (j1 == j2) {
                float val;
                if ((val = this.mData[i1++] * right.mData[i2++]) == 0.0f) continue;
                resultInd[nnz] = j1;
                resultData[nnz++] = val;
                continue;
            }
            if (j1 < j2) {
                ++i1;
                continue;
            }
            ++i2;
        }
        if (nnz == resultInd.length) {
            return new SparseVector(resultInd, resultData);
        }
        return new SparseVector(Arrays.copyOf(resultInd, nnz), Arrays.copyOf(resultData, nnz));
    }

    float sum() {
        float sum = 0.0f;
        for (float v : this.mData) {
            sum += v;
        }
        return sum;
    }
}

