/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

final class Curve {
    private static final float[][] SPREAD_DIST_AS = new float[][]{new float[0], new float[0], new float[0], new float[0], new float[0], {0.0f, 5.45377f, 5.06931f, 4.63694f, 4.17619f, 3.70629f, 3.24352f, 2.8006f, 2.38675f, 2.00802f, 1.66772f, 1.36696f}, {0.0f, 4.00306f, 3.65757f, 3.30358f, 2.95032f, 2.60637f, 2.27854f, 1.97183f, 1.68955f, 1.43356f, 1.2045f, 1.00209f, 0.82529f, 0.67254f}, {0.0f, 3.10329f, 2.81124f, 2.52444f, 2.2475f, 1.98435f, 1.73792f, 1.51015f, 1.30214f, 1.11425f, 0.94625f, 0.79748f, 0.6669f, 0.5533f, 0.4553f, 0.37144f}, {0.0f, 2.4988f, 2.25458f, 2.02012f, 1.79779f, 1.58943f, 1.39624f, 1.21887f, 1.0575f, 0.91192f, 0.78165f, 0.66593f, 0.56388f, 0.47451f, 0.39679f, 0.32963f, 0.27198f, 0.2228f}, {0.0f, 2.06902f, 1.86409f, 1.66991f, 1.48771f, 1.31831f, 1.16212f, 1.01922f, 0.88942f, 0.7723f, 0.66732f, 0.57375f, 0.4909f, 0.41788f, 0.35395f, 0.29823f, 0.24996f, 0.20833f, 0.17265f, 0.14221f}, {0.0f, 1.75022f, 1.57694f, 1.414f, 1.26206f, 1.12144f, 0.99218f, 0.8741f, 0.76687f, 0.67003f, 0.58303f, 0.50526f, 0.43607f, 0.37481f, 0.32082f, 0.27345f, 0.23206f, 0.19607f, 0.1649f, 0.13804f, 0.11498f, 0.09527f}, {0.0f, 1.50587f, 1.35804f, 1.21967f, 1.09109f, 0.9724f, 0.86343f, 0.76395f, 0.67354f, 0.59177f, 0.51814f, 0.45211f, 0.39314f, 0.34068f, 0.2942f, 0.25316f, 0.21708f, 0.18544f, 0.15784f, 0.13382f, 0.11302f, 0.09505f, 0.0796f, 0.06635f}, {0.0f, 1.3136f, 1.18637f, 1.06759f, 0.95743f, 0.85584f, 0.76262f, 0.67747f, 0.60002f, 0.52985f, 0.4665f, 0.40952f, 0.35843f, 0.3128f, 0.27218f, 0.23613f, 0.20424f, 0.17611f, 0.15137f, 0.1297f, 0.11076f, 0.09428f, 0.07997f, 0.06758f, 0.0569f, 0.04771f}, {0.0f, 1.15902f, 1.04861f, 0.94567f, 0.85027f, 0.76232f, 0.68159f, 0.6078f, 0.54058f, 0.47955f, 0.42432f, 0.37449f, 0.32967f, 0.2895f, 0.25358f, 0.22154f, 0.19304f, 0.16777f, 0.14542f, 0.12571f, 0.10837f, 0.09316f, 0.07985f, 0.06824f, 0.05813f, 0.04936f, 0.04178f, 0.03524f}, {0.0f, 1.03253f, 0.93595f, 0.84598f, 0.76261f, 0.68572f, 0.6151f, 0.55045f, 0.49148f, 0.4378f, 0.38915f, 0.34512f, 0.3054f, 0.26965f, 0.23756f, 0.20883f, 0.18315f, 0.16028f, 0.13992f, 0.12189f, 0.10591f, 0.09182f, 0.0794f, 0.06848f, 0.05892f, 0.05055f, 0.04325f, 0.0369f, 0.03139f, 0.02662f}, {0.0f, 0.92742f, 0.84237f, 0.76312f, 0.68968f, 0.62189f, 0.55955f, 0.50242f, 0.45021f, 0.4026f, 0.35933f, 0.32008f, 0.28455f, 0.25248f, 0.22359f, 0.19762f, 0.17432f, 0.15347f, 0.13483f, 0.11822f, 0.10345f, 0.09033f, 0.0787f, 0.06843f, 0.05936f, 0.05137f, 0.04437f, 0.03821f, 0.03283f, 0.02814f, 0.02405f, 0.0205f}, {0.0f, 0.83896f, 0.76357f, 0.6933f, 0.62813f, 0.56793f, 0.5125f, 0.46161f, 0.41501f, 0.37246f, 0.33368f, 0.29843f, 0.26643f, 0.23745f, 0.21126f, 0.18763f, 0.16635f, 0.14723f, 0.13008f, 0.11472f, 0.101f, 0.08875f, 0.07784f, 0.06815f, 0.05954f, 0.05192f, 0.04518f, 0.03924f, 0.03401f, 0.02941f, 0.02537f, 0.02184f, 0.01875f, 0.01606f}};
    private static final float[][] SPREAD_DIST_BS = new float[][]{new float[0], new float[0], new float[0], new float[0], new float[0], {0.0f, 0.89506f, 1.00301f, 1.11225f, 1.22256f, 1.33417f, 1.44746f, 1.56295f, 1.68123f, 1.80304f, 1.92924f, 2.0609f}, {0.0f, 0.87728f, 0.96682f, 1.0575f, 1.14889f, 1.24105f, 1.33417f, 1.42845f, 1.52416f, 1.6217f, 1.72144f, 1.82373f, 1.92923f, 2.03858f}, {0.0f, 0.86464f, 0.94109f, 1.01853f, 1.09656f, 1.17513f, 1.25429f, 1.33417f, 1.41491f, 1.49668f, 1.57967f, 1.66414f, 1.75035f, 1.83859f, 1.92923f, 2.02267f}, {0.0f, 0.8552f, 0.92186f, 0.98941f, 1.0575f, 1.12598f, 1.19486f, 1.26423f, 1.33417f, 1.40477f, 1.4761f, 1.54836f, 1.6217f, 1.69629f, 1.77222f, 1.84979f, 1.92924f, 2.01085f}, {0.0f, 0.84788f, 0.90695f, 0.96682f, 1.02719f, 1.08787f, 1.14889f, 1.21024f, 1.27197f, 1.33417f, 1.39686f, 1.46019f, 1.52416f, 1.58901f, 1.65466f, 1.72144f, 1.7893f, 1.85855f, 1.92924f, 2.00165f}, {0.0f, 0.84206f, 0.89506f, 0.94882f, 1.00301f, 1.0575f, 1.11225f, 1.16727f, 1.22256f, 1.27818f, 1.33417f, 1.39057f, 1.44746f, 1.5049f, 1.56295f, 1.6217f, 1.68123f, 1.74165f, 1.80304f, 1.86553f, 1.92924f, 1.99431f}, {0.0f, 0.83729f, 0.88535f, 0.93409f, 0.98326f, 1.03268f, 1.08235f, 1.13221f, 1.18231f, 1.23264f, 1.28324f, 1.33417f, 1.38541f, 1.43709f, 1.48916f, 1.54179f, 1.59489f, 1.6487f, 1.70309f, 1.75832f, 1.81431f, 1.87129f, 1.92923f, 1.98835f}, {0.0f, 0.83333f, 0.87728f, 0.92186f, 0.96682f, 1.01206f, 1.0575f, 1.10311f, 1.14889f, 1.19486f, 1.24105f, 1.28747f, 1.33417f, 1.38116f, 1.42845f, 1.4761f, 1.52416f, 1.57268f, 1.6217f, 1.67128f, 1.72144f, 1.77222f, 1.82373f, 1.87604f, 1.92923f, 1.98338f}, {0.0f, 0.82999f, 0.87046f, 0.91153f, 0.95296f, 0.99464f, 1.03652f, 1.07852f, 1.12068f, 1.16301f, 1.2055f, 1.24819f, 1.29109f, 1.33417f, 1.3775f, 1.42113f, 1.46506f, 1.50934f, 1.55401f, 1.59903f, 1.6445f, 1.69046f, 1.73696f, 1.78405f, 1.83178f, 1.88014f, 1.92924f, 1.97915f}, {0.0f, 0.82713f, 0.86464f, 0.90269f, 0.94109f, 0.97973f, 1.01853f, 1.0575f, 1.09656f, 1.13581f, 1.17513f, 1.21464f, 1.25429f, 1.29413f, 1.33417f, 1.3744f, 1.41491f, 1.45562f, 1.49668f, 1.53798f, 1.57967f, 1.6217f, 1.66414f, 1.70703f, 1.75035f, 1.79425f, 1.83859f, 1.88363f, 1.92924f, 1.97558f}, {0.0f, 0.82465f, 0.8596f, 0.89506f, 0.93083f, 0.96682f, 1.00301f, 1.03929f, 1.0757f, 1.11225f, 1.14889f, 1.18565f, 1.22256f, 1.2596f, 1.29678f, 1.33417f, 1.37172f, 1.40946f, 1.44746f, 1.4857f, 1.52416f, 1.56295f, 1.60206f, 1.64145f, 1.68124f, 1.72144f, 1.76198f, 1.80304f, 1.84462f, 1.88662f, 1.92923f, 1.97251f}, {0.0f, 0.82249f, 0.8552f, 0.88837f, 0.92186f, 0.95555f, 0.98941f, 1.0234f, 1.0575f, 1.0917f, 1.12598f, 1.16036f, 1.19486f, 1.22948f, 1.26423f, 1.29912f, 1.33417f, 1.36938f, 1.40477f, 1.44033f, 1.4761f, 1.51211f, 1.54836f, 1.58489f, 1.6217f, 1.65883f, 1.69629f, 1.73407f, 1.77222f, 1.81079f, 1.84979f, 1.88926f, 1.92923f, 1.96975f}};

    private Curve() {
    }

    private static float findValue(float[][] spreadDist, int spreadIndex, int distIndex, float spreadDelta, float distDelta) {
        float start = spreadDist[spreadIndex][distIndex] + distDelta * (spreadDist[spreadIndex][distIndex + 1] - spreadDist[spreadIndex][distIndex]);
        float end = spreadDist[spreadIndex + 1][distIndex] + distDelta * (spreadDist[spreadIndex + 1][distIndex + 1] - spreadDist[spreadIndex + 1][distIndex]);
        return start + spreadDelta * (end - start);
    }

    public static float[] curveFit(float spread, float minDist) {
        if (spread < 0.5f || spread > 1.5f) {
            throw new IllegalArgumentException("Spread must be in the range 0.5 < spread <= 1.5, got : " + spread);
        }
        if (minDist < 0.0f || minDist > spread) {
            throw new IllegalArgumentException("Expecting 0 < minDist < " + spread + ", got : " + minDist);
        }
        int spreadIndex = (int)(10.0f * spread);
        float spreadDelta = (10.0f * spread - (float)spreadIndex) / 10.0f;
        int distIndex = (int)(20.0f * minDist);
        float distDelta = (20.0f * minDist - (float)distIndex) / 20.0f;
        float a = Curve.findValue(SPREAD_DIST_AS, spreadIndex, distIndex, spreadDelta, distDelta);
        float b = Curve.findValue(SPREAD_DIST_BS, spreadIndex, distIndex, spreadDelta, distDelta);
        return new float[]{a, b};
    }

    private static double curve(float x, float a, float b) {
        return 1.0 / (1.0 + (double)a * Math.pow(x, 2.0f * b));
    }

    private static float[] wrapCurve(float[] x, float[] y, float a, float b) {
        float[] res = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            res[i] = (float)(Curve.curve(x[i], a, b) - (double)y[i]);
        }
        return res;
    }

    private static void checkValues(float[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Array must not be empty.");
        }
        for (float value : data) {
            if (!Float.isNaN(value) && !Float.isInfinite(value)) continue;
            throw new IllegalArgumentException("Array cannot contain NaN or Infinity.");
        }
    }
}

