/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import tagbio.umap.metric.Metric;

public final class JaccardMetric
extends Metric {
    public static final JaccardMetric SINGLETON = new JaccardMetric();

    private JaccardMetric() {
        super(true);
    }

    @Override
    public float distance(float[] x, float[] y) {
        int numNonZero = 0;
        int numEqual = 0;
        for (int i = 0; i < x.length; ++i) {
            boolean xTrue = x[i] != 0.0f;
            boolean yTrue = y[i] != 0.0f;
            numNonZero += xTrue || yTrue ? 1 : 0;
            numEqual += xTrue && yTrue ? 1 : 0;
        }
        if (numNonZero == 0) {
            return 0.0f;
        }
        return (float)(numNonZero - numEqual) / (float)numNonZero;
    }
}

