/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap.metric;

import tagbio.umap.metric.Metric;

public final class CorrelationMetric
extends Metric {
    public static final CorrelationMetric SINGLETON = new CorrelationMetric();

    private CorrelationMetric() {
        super(true);
    }

    @Override
    public float distance(float[] x, float[] y) {
        int i;
        float muX = 0.0f;
        float muY = 0.0f;
        float normX = 0.0f;
        float normY = 0.0f;
        float dotProduct = 0.0f;
        for (i = 0; i < x.length; ++i) {
            muX += x[i];
            muY += y[i];
        }
        muX /= (float)x.length;
        muY /= (float)x.length;
        for (i = 0; i < x.length; ++i) {
            float shiftedX = x[i] - muX;
            float shiftedY = y[i] - muY;
            normX += shiftedX * shiftedX;
            normY += shiftedY * shiftedY;
            dotProduct += shiftedX * shiftedY;
        }
        if ((double)normX == 0.0 && (double)normY == 0.0) {
            return 0.0f;
        }
        if ((double)dotProduct == 0.0) {
            return 1.0f;
        }
        return (float)(1.0 - (double)dotProduct / Math.sqrt(normX * normY));
    }
}

