/*
 * Decompiled with CFR 0.152.
 */
package tagbio.umap;

import java.util.Arrays;
import tagbio.umap.CooMatrix;
import tagbio.umap.CsrMatrix;
import tagbio.umap.DefaultMatrix;
import tagbio.umap.MathUtils;
import tagbio.umap.Utils;

public abstract class Matrix {
    private final int mRowCount;
    private final int mColCount;

    Matrix(int rows, int cols) {
        if (rows < 0) {
            throw new IllegalArgumentException("Illegal rows specification: " + rows);
        }
        if (cols < 0) {
            throw new IllegalArgumentException("Illegal cols specification: " + cols);
        }
        this.mRowCount = rows;
        this.mColCount = cols;
    }

    abstract float get(int var1, int var2);

    abstract void set(int var1, int var2, float var3);

    abstract boolean isFinite();

    int rows() {
        return this.mRowCount;
    }

    int cols() {
        return this.mColCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int row = 0; row < this.rows(); ++row) {
            for (int col = 0; col < this.cols(); ++col) {
                if (col > 0) {
                    sb.append(',');
                }
                sb.append(this.get(row, col));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toStringNumpy() {
        StringBuilder sb = new StringBuilder("np.matrix([");
        for (int row = 0; row < this.rows(); ++row) {
            sb.append('[');
            for (int col = 0; col < this.cols(); ++col) {
                if (col > 0) {
                    sb.append(',');
                }
                sb.append(this.get(row, col));
            }
            sb.append("],");
        }
        sb.append("])");
        return sb.toString();
    }

    protected boolean isShapeSame(Matrix m) {
        return this.mRowCount == m.mRowCount && this.mColCount == m.mColCount;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Matrix)) {
            return false;
        }
        Matrix m = (Matrix)obj;
        if (!this.isShapeSame(m)) {
            return false;
        }
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                if (this.get(i, j) == m.get(i, j)) continue;
                return false;
            }
        }
        return true;
    }

    long length() {
        return this.mRowCount * this.mColCount;
    }

    Matrix transpose() {
        float[][] res = new float[this.cols()][this.rows()];
        for (int i = 0; i < this.rows(); ++i) {
            for (int j = 0; j < this.cols(); ++j) {
                res[j][i] = this.get(i, j);
            }
        }
        return new DefaultMatrix(res);
    }

    Matrix add(Matrix m) {
        if (!this.isShapeSame(m)) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        DefaultMatrix res = new DefaultMatrix(this.mRowCount, this.mColCount);
        int rows = this.rows();
        int cols = this.cols();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                res.set(i, j, this.get(i, j) + m.get(i, j));
            }
        }
        return res;
    }

    Matrix subtract(Matrix m) {
        if (!this.isShapeSame(m)) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        DefaultMatrix res = new DefaultMatrix(this.mRowCount, this.mColCount);
        int rows = this.rows();
        int cols = this.cols();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                res.set(i, j, this.get(i, j) - m.get(i, j));
            }
        }
        return res;
    }

    Matrix multiply(float x) {
        DefaultMatrix res = new DefaultMatrix(this.mRowCount, this.mColCount);
        int rows = this.rows();
        int cols = this.cols();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                res.set(i, j, this.get(i, j) * x);
            }
        }
        return res;
    }

    Matrix multiply(Matrix m) {
        if (this.cols() != m.rows()) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        int rows = this.rows();
        int cols = m.cols();
        DefaultMatrix res = new DefaultMatrix(rows, cols);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < this.cols(); ++k) {
                    sum += this.get(i, k) * m.get(k, j);
                }
                ((Matrix)res).set(i, j, sum);
            }
        }
        return res;
    }

    Matrix hadamardMultiply(Matrix m) {
        if (!this.isShapeSame(m)) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        DefaultMatrix res = new DefaultMatrix(this.mRowCount, this.mColCount);
        int rows = this.rows();
        int cols = this.cols();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                res.set(i, j, this.get(i, j) * m.get(i, j));
            }
        }
        return res;
    }

    Matrix hadamardMultiplyTranspose() {
        if (this.rows() != this.cols()) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        return this.hadamardMultiply(this.transpose());
    }

    Matrix addTranspose() {
        if (this.rows() != this.cols()) {
            throw new IllegalArgumentException("Incompatible matrix sizes");
        }
        return this.add(this.transpose());
    }

    private int countZeros() {
        int cnt = 0;
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.cols(); ++c) {
                if (this.get(r, c) != 0.0f) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    Matrix eliminateZeros() {
        throw new UnsupportedOperationException();
    }

    CooMatrix toCoo() {
        int len = (int)(this.length() - (long)this.countZeros());
        int[] row = new int[len];
        int[] col = new int[len];
        float[] data = new float[len];
        int k = 0;
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.cols(); ++c) {
                float x = this.get(r, c);
                if (x == 0.0f) continue;
                row[k] = r;
                col[k] = c;
                data[k++] = x;
            }
        }
        return new CooMatrix(data, row, col, this.mRowCount, this.mColCount);
    }

    CsrMatrix toCsr() {
        int len = (int)(this.length() - (long)this.countZeros());
        int[] indptr = new int[this.rows() + 1];
        int[] indices = new int[len];
        float[] data = new float[len];
        int k = 0;
        for (int r = 0; r < this.rows(); ++r) {
            indptr[r] = k;
            for (int c = 0; c < this.cols(); ++c) {
                float x = this.get(r, c);
                if (x == 0.0f) continue;
                indices[k] = c;
                data[k++] = x;
            }
        }
        indptr[this.rows()] = len;
        return new CsrMatrix(data, indptr, indices, this.mRowCount, this.mColCount);
    }

    Matrix copy() {
        throw new UnsupportedOperationException();
    }

    float[][] toArray() {
        float[][] res = new float[this.rows()][this.cols()];
        for (int r = 0; r < this.rows(); ++r) {
            for (int c = 0; c < this.cols(); ++c) {
                res[r][c] = this.get(r, c);
            }
        }
        return res;
    }

    float[] row(int row) {
        float[] data = new float[this.cols()];
        for (int k = 0; k < data.length; ++k) {
            data[k] = this.get(row, k);
        }
        return data;
    }

    Matrix max(Matrix other) {
        if (!this.isShapeSame(other)) {
            throw new IllegalArgumentException("Incompatible sizes");
        }
        DefaultMatrix m = new DefaultMatrix(this.mRowCount, this.mColCount);
        for (int k = 0; k < this.rows(); ++k) {
            for (int j = 0; j < this.cols(); ++j) {
                m.set(k, j, Math.max(this.get(k, j), other.get(k, j)));
            }
        }
        return m;
    }

    Matrix rowNormalize() {
        float[][] d = new float[this.rows()][];
        for (int k = 0; k < this.rows(); ++k) {
            float[] row = this.row(k);
            float max = MathUtils.max(row);
            if (max == 0.0f) {
                d[k] = Arrays.copyOf(row, this.cols());
                continue;
            }
            d[k] = new float[this.cols()];
            for (int j = 0; j < this.cols(); ++j) {
                d[k][j] = row[j] / max;
            }
        }
        return new DefaultMatrix(d);
    }

    Matrix l1Normalize() {
        float[][] d = new float[this.rows()][];
        for (int k = 0; k < this.rows(); ++k) {
            float[] row = this.row(k);
            float l1 = Utils.norm(row);
            if (l1 == 0.0f) {
                d[k] = Arrays.copyOf(row, this.cols());
                continue;
            }
            d[k] = new float[this.cols()];
            for (int j = 0; j < this.cols(); ++j) {
                d[k][j] = row[j] / l1;
            }
        }
        return new DefaultMatrix(d);
    }
}

