/*
 * Decompiled with CFR 0.152.
 */
package tech.liujin.widget.pager;

import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import tech.liujin.widget.pager.BasePagerAdapter;
import tech.liujin.widget.pager.PagerItemInfo;

class PagerItemPool<D, V extends View> {
    private ArrayList<PagerItemInfo<D, V>> mItemsInfo = new ArrayList();
    private BasePagerAdapter<D, V> mPagerAdapter;

    PagerItemPool(BasePagerAdapter<D, V> pagerAdapter) {
        this.mPagerAdapter = pagerAdapter;
    }

    public PagerItemInfo<D, V> getPagerItemInfo(ViewGroup container, int position) {
        PagerItemInfo itemInfo = null;
        ArrayList<PagerItemInfo<D, V>> itemsInfo = this.mItemsInfo;
        for (int i = 0; i < itemsInfo.size(); ++i) {
            PagerItemInfo<D, V> infoNew = itemsInfo.get(i);
            if (infoNew.getPosition() != -1) continue;
            itemInfo = infoNew;
            break;
        }
        if (itemInfo == null) {
            itemInfo = new PagerItemInfo();
            itemsInfo.add(itemInfo);
        }
        itemInfo.setPosition(position);
        D data = this.mPagerAdapter.getData(position);
        itemInfo.setData(data);
        Object view = itemInfo.getView();
        if (view == null) {
            view = this.mPagerAdapter.getView(container, position);
            itemInfo.setView(view);
        }
        this.mPagerAdapter.bindData(position, data, view);
        return itemInfo;
    }

    public PagerItemInfo<D, V> getPagerItem(int position) {
        int size = this.mItemsInfo.size();
        for (int i = 0; i < size; ++i) {
            PagerItemInfo<D, V> info = this.mItemsInfo.get(i);
            if (info.getPosition() != position) continue;
            return info;
        }
        return null;
    }
}

