/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.util;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class ByteUtils {
    public static final Pattern HEXADECIMAL_PATTERN = Pattern.compile("\\p{XDigit}+");

    public static String bytesToHex(byte[] data, int length) {
        String digits = "0123456789abcdef";
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i != length; ++i) {
            int v = data[i] & 0xFF;
            buffer.append(digits.charAt(v >> 4));
            buffer.append(digits.charAt(v & 0xF));
        }
        return buffer.toString();
    }

    public static String bytesToHex(byte[] data) {
        return ByteUtils.bytesToHex(data, data.length);
    }

    public static String bytesToHex(byte[] data, int offset, int length) {
        String digits = "0123456789abcdef";
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i != length; ++i) {
            int v = data[offset + i] & 0xFF;
            buffer.append(digits.charAt(v >> 4));
            buffer.append(digits.charAt(v & 0xF));
        }
        return buffer.toString();
    }

    public static String byteToHexBlock(byte[] data) {
        return ByteUtils.byteToHexBlock(data, data.length);
    }

    public static String byteToHexBlock(byte[] data, int length) {
        Object result = "";
        int i = 0;
        while (i < length) {
            result = (String)result + String.format("%02x ", data[i]);
            if (++i >= data.length) continue;
            if (i % 16 == 0) {
                result = (String)result + "\n";
                continue;
            }
            if (i % 8 != 0) continue;
            result = (String)result + " ";
        }
        return result;
    }

    public static String byteToHexBlock(ByteBuffer data, int start, int size) {
        int initialPosition = data.position();
        data.position(start);
        byte[] dataBytes = new byte[size];
        data.get(dataBytes);
        data.position(initialPosition);
        return ByteUtils.byteToHexBlock(dataBytes);
    }

    public static byte[] hexToBytes(String hex) {
        if (!HEXADECIMAL_PATTERN.matcher(hex = hex.replace(" ", "")).matches()) {
            throw new IllegalArgumentException("Input should be hexadecimal string");
        }
        int length = hex.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return data;
    }
}

