/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.handshake;

import java.nio.ByteBuffer;
import java.util.List;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.TlsProtocolException;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.Extension;
import tech.kwik.agent15.handshake.HandshakeMessage;

public class CertificateRequestMessage
extends HandshakeMessage {
    private static final int MINIMUM_MESSAGE_SIZE = 7;
    private byte[] certificateRequestContext;
    private List<Extension> extensions;
    private byte[] raw;

    public CertificateRequestMessage() {
    }

    public CertificateRequestMessage(Extension extension) {
        this.extensions = List.of(extension);
        this.certificateRequestContext = new byte[0];
        this.serialize();
    }

    public CertificateRequestMessage parse(ByteBuffer buffer) throws TlsProtocolException {
        int startPosition = buffer.position();
        int remainingLength = this.parseHandshakeHeader(buffer, TlsConstants.HandshakeType.certificate_request, 7);
        byte contextLength = buffer.get();
        this.certificateRequestContext = new byte[contextLength];
        if (contextLength > 0) {
            buffer.get(this.certificateRequestContext);
        }
        this.extensions = CertificateRequestMessage.parseExtensions(buffer, TlsConstants.HandshakeType.certificate_request, null);
        if (buffer.position() - (startPosition + 4) != remainingLength) {
            throw new DecodeErrorException("inconsistent length");
        }
        this.raw = new byte[4 + remainingLength];
        buffer.position(startPosition);
        buffer.get(this.raw);
        return this;
    }

    private void serialize() {
        int extensionsLength = this.extensions.stream().mapToInt(ext -> ext.getBytes().length).sum();
        int messageLength = 5 + this.certificateRequestContext.length + 2 + extensionsLength;
        ByteBuffer buffer = ByteBuffer.allocate(messageLength);
        buffer.put(TlsConstants.HandshakeType.certificate_request.value);
        buffer.put((byte)0);
        buffer.putShort((short)(messageLength - 4));
        buffer.put((byte)this.certificateRequestContext.length);
        if (this.certificateRequestContext.length > 0) {
            buffer.put(this.certificateRequestContext);
        }
        buffer.putShort((short)extensionsLength);
        for (Extension extension : this.extensions) {
            buffer.put(extension.getBytes());
        }
        this.raw = buffer.array();
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.certificate_request;
    }

    @Override
    public byte[] getBytes() {
        return this.raw;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }
}

