/*
 * Decompiled with CFR 0.152.
 */
package tech.kwik.agent15.extension;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import tech.kwik.agent15.TlsConstants;
import tech.kwik.agent15.alert.DecodeErrorException;
import tech.kwik.agent15.extension.Extension;

public class ApplicationLayerProtocolNegotiationExtension
extends Extension {
    private final List<String> protocols;

    public ApplicationLayerProtocolNegotiationExtension(String protocol) {
        if (protocol == null || protocol.trim().isEmpty()) {
            throw new IllegalArgumentException("protocol cannot be empty");
        }
        this.protocols = List.of(protocol);
    }

    public ApplicationLayerProtocolNegotiationExtension(List<String> protocols) {
        if (protocols.isEmpty()) {
            throw new IllegalArgumentException("list of protocols can't be empty");
        }
        if (protocols.stream().anyMatch(s -> s.trim().isEmpty())) {
            throw new IllegalArgumentException("protocol cannot be empty");
        }
        this.protocols = protocols;
    }

    public ApplicationLayerProtocolNegotiationExtension(ByteBuffer buffer) throws DecodeErrorException {
        int protocolNameLength;
        int protocolsLength;
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.application_layer_protocol_negotiation.value, 3);
        if (protocolsLength != extensionDataLength - 2) {
            throw new DecodeErrorException("inconsistent lengths");
        }
        this.protocols = new ArrayList<String>();
        for (protocolsLength = buffer.getShort(); protocolsLength > 0; protocolsLength -= 1 + protocolNameLength) {
            protocolNameLength = buffer.get() & 0xFF;
            if (protocolNameLength > protocolsLength - 1) {
                throw new DecodeErrorException("incorrect length");
            }
            byte[] protocolBytes = new byte[protocolNameLength];
            buffer.get(protocolBytes);
            this.protocols.add(new String(protocolBytes));
        }
    }

    @Override
    public byte[] getBytes() {
        int protocolNamesLength = this.protocols.stream().mapToInt(p -> p.getBytes(Charset.forName("UTF-8")).length).sum();
        int size = 6 + this.protocols.size() + protocolNamesLength;
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.putShort(TlsConstants.ExtensionType.application_layer_protocol_negotiation.value);
        buffer.putShort((short)(size - 4));
        buffer.putShort((short)(size - 6));
        this.protocols.forEach(protocol -> {
            byte[] protocolName = protocol.getBytes(Charset.forName("UTF-8"));
            buffer.put((byte)protocolName.length);
            buffer.put(protocolName);
        });
        return buffer.array();
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public String toString() {
        return "AlpnExtension " + String.valueOf(this.protocols);
    }
}

