/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.env;

import net.luminis.tls.env.AlgorithmMapping;

public class PlatformMapping {
    private static Platform currentPlatform;

    public static void usePlatformMapping(Platform platform) {
        if (currentPlatform == null) {
            currentPlatform = platform;
        } else if (platform != currentPlatform) {
            throw new IllegalArgumentException("Once set, platform cannot be changed");
        }
    }

    public static AlgorithmMapping algorithmMapping() {
        if (currentPlatform == Platform.Android) {
            return new AndroidMapping();
        }
        return new IdentityMapping();
    }

    private static class AndroidMapping
    implements AlgorithmMapping {
        private AndroidMapping() {
        }

        @Override
        public String get(String value) {
            if (value == null) {
                return null;
            }
            if (value.equals("RSASSA-PSS")) {
                return "SHA256withRSA/PSS";
            }
            return value;
        }
    }

    private static class IdentityMapping
    implements AlgorithmMapping {
        private IdentityMapping() {
        }

        @Override
        public String get(String value) {
            return value;
        }
    }

    public static enum Platform {
        JDK,
        Android;

    }
}

