/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.engine;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.compat.InputStreamCompat;
import net.luminis.tls.engine.ServerMessageSender;
import net.luminis.tls.engine.TlsServerEngine;
import net.luminis.tls.engine.TlsSessionRegistry;
import net.luminis.tls.engine.TlsStatusEventHandler;
import net.luminis.tls.engine.impl.TlsServerEngineImpl;
import net.luminis.tls.engine.impl.TlsSessionRegistryImpl;

public class TlsServerEngineFactory {
    private final List<X509Certificate> certificateChain;
    private final PrivateKey certificateKey;
    private final TlsSessionRegistry tlsSessionRegistry = new TlsSessionRegistryImpl();
    private final List<TlsConstants.SignatureScheme> preferredSignatureSchemes;

    @Deprecated
    public TlsServerEngineFactory(InputStream certificateFile, InputStream certificateKeyFile) throws IOException, CertificateException, InvalidKeySpecException {
        this(TlsServerEngineFactory.readCertificates(certificateFile), TlsServerEngineFactory.readPrivateKey(certificateKeyFile), null);
    }

    public TlsServerEngineFactory(KeyStore keyStore, String alias, char[] keyPassword) throws IOException, CertificateException, InvalidKeySpecException {
        this(TlsServerEngineFactory.getCertificates(keyStore, alias), TlsServerEngineFactory.getPrivateKey(keyStore, alias, keyPassword), null);
    }

    public TlsServerEngineFactory(KeyStore keyStore, String alias, char[] keyPassword, String ecCurve) throws IOException, CertificateException, InvalidKeySpecException {
        this(TlsServerEngineFactory.getCertificates(keyStore, alias), TlsServerEngineFactory.getPrivateKey(keyStore, alias, keyPassword), ecCurve);
    }

    private TlsServerEngineFactory(List<X509Certificate> certificateChain, PrivateKey certificateKey, String ecCurve) throws CertificateException {
        this.certificateChain = certificateChain;
        this.certificateKey = certificateKey;
        this.preferredSignatureSchemes = TlsServerEngineFactory.preferredSignatureSchemes(certificateChain.get(0), ecCurve);
    }

    private static List<X509Certificate> getCertificates(KeyStore keyStore, String alias) {
        try {
            return Arrays.stream(keyStore.getCertificateChain(alias)).map(c -> (X509Certificate)c).collect(Collectors.toList());
        }
        catch (KeyStoreException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static PrivateKey getPrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (KeyStoreException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Algorithm not supported", e);
        }
    }

    public TlsServerEngine createServerEngine(ServerMessageSender serverMessageSender, TlsStatusEventHandler tlsStatusHandler) {
        TlsServerEngineImpl tlsServerEngine = new TlsServerEngineImpl(this.certificateChain, this.certificateKey, this.preferredSignatureSchemes, serverMessageSender, tlsStatusHandler, this.tlsSessionRegistry);
        tlsServerEngine.addSupportedCiphers(List.of(TlsConstants.CipherSuite.TLS_AES_128_GCM_SHA256));
        return tlsServerEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static List<TlsConstants.SignatureScheme> preferredSignatureSchemes(X509Certificate certificate, String ecCurve) throws CertificateException {
        LinkedHashSet<TlsConstants.SignatureScheme> preferred = new LinkedHashSet<TlsConstants.SignatureScheme>();
        String algorithm = certificate.getPublicKey().getAlgorithm();
        if (algorithm.equals("RSA")) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)certificate.getPublicKey();
            int keySize = rsaPublicKey.getModulus().bitLength();
            if (keySize <= 2048) {
                preferred.add(TlsConstants.SignatureScheme.rsa_pss_rsae_sha256);
            } else if (keySize >= 4096) {
                preferred.add(TlsConstants.SignatureScheme.rsa_pss_rsae_sha512);
            } else {
                preferred.add(TlsConstants.SignatureScheme.rsa_pss_rsae_sha384);
            }
            preferred.addAll(List.of(TlsConstants.SignatureScheme.rsa_pss_rsae_sha256, TlsConstants.SignatureScheme.rsa_pss_rsae_sha384, TlsConstants.SignatureScheme.rsa_pss_rsae_sha512));
            return new ArrayList<TlsConstants.SignatureScheme>(preferred);
        } else {
            String curveName;
            if (!algorithm.equals("EC")) throw new CertificateException("Unsupported certificate type " + algorithm);
            String string = curveName = ecCurve != null ? ecCurve : TlsServerEngineFactory.determineCurveName(certificate);
            if (curveName == null) throw new CertificateException("Unable to extract EC curve name from certificate (with public key: " + certificate.getPublicKey() + ")");
            switch (curveName) {
                case "secp256r1": {
                    preferred.add(TlsConstants.SignatureScheme.ecdsa_secp256r1_sha256);
                    return new ArrayList<TlsConstants.SignatureScheme>(preferred);
                }
                case "secp384r1": {
                    preferred.add(TlsConstants.SignatureScheme.ecdsa_secp384r1_sha384);
                    return new ArrayList<TlsConstants.SignatureScheme>(preferred);
                }
                case "secp521r1": {
                    preferred.add(TlsConstants.SignatureScheme.ecdsa_secp521r1_sha512);
                    return new ArrayList<TlsConstants.SignatureScheme>(preferred);
                }
                default: {
                    throw new CertificateException("Unsupported EC curve " + curveName);
                }
            }
        }
    }

    private static String determineCurveName(Certificate certificate) {
        ECPublicKey ecPublicKey = (ECPublicKey)certificate.getPublicKey();
        ECParameterSpec params = ecPublicKey.getParams();
        String paramsContents = params.toString();
        if (paramsContents.contains(" ")) {
            return paramsContents.substring(0, paramsContents.indexOf(" "));
        }
        return null;
    }

    private static List<X509Certificate> readCertificates(InputStream file) throws IOException, CertificateException {
        String fileContent = new String(InputStreamCompat.readAllBytes(file), Charset.defaultCharset());
        String[] chunks = fileContent.split("-----END CERTIFICATE-----\n");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        for (int i = 0; i < chunks.length; ++i) {
            if (!chunks[i].startsWith("-----BEGIN CERTIFICATE-----")) continue;
            String encodedCertificate = chunks[i].replace("-----BEGIN CERTIFICATE-----", "").replaceAll(System.lineSeparator(), "").replace("-----END CERTIFICATE-----", "");
            Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(Base64.getDecoder().decode(encodedCertificate)));
            certs.add((X509Certificate)certificate);
        }
        return certs;
    }

    private static RSAPrivateKey readPrivateKey(InputStream file) throws IOException, InvalidKeySpecException {
        String key = new String(InputStreamCompat.readAllBytes(file), Charset.defaultCharset());
        String privateKeyPEM = key.replace("-----BEGIN PRIVATE KEY-----", "").replaceAll(System.lineSeparator(), "").replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = Base64.getMimeDecoder().decode(privateKeyPEM);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing key algorithm RSA");
        }
    }
}

