/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.extension;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.extension.Extension;

public class SignatureAlgorithmsExtension
extends Extension {
    private List<TlsConstants.SignatureScheme> algorithms = new ArrayList<TlsConstants.SignatureScheme>();

    public SignatureAlgorithmsExtension() {
        this.algorithms = Collections.emptyList();
    }

    public SignatureAlgorithmsExtension(List<TlsConstants.SignatureScheme> signatureSchemes) {
        this.algorithms = signatureSchemes;
    }

    public SignatureAlgorithmsExtension(TlsConstants.SignatureScheme ... signatureAlgorithms) {
        this.algorithms = List.of(signatureAlgorithms);
    }

    public SignatureAlgorithmsExtension(ByteBuffer buffer) throws DecodeErrorException {
        int extensionDataLength = this.parseExtensionHeader(buffer, TlsConstants.ExtensionType.signature_algorithms, 4);
        int supportedAlgorithmsLength = buffer.getShort();
        if (extensionDataLength != 2 + supportedAlgorithmsLength) {
            throw new DecodeErrorException("inconsistent length");
        }
        if (supportedAlgorithmsLength % 2 != 0) {
            throw new DecodeErrorException("invalid group length");
        }
        for (int i = 0; i < supportedAlgorithmsLength; i += 2) {
            int supportedAlgorithmBytes = buffer.getShort() % 65535;
            TlsConstants.decodeSignatureScheme(supportedAlgorithmBytes).ifPresent(algorithm -> this.algorithms.add((TlsConstants.SignatureScheme)((Object)algorithm)));
        }
    }

    @Override
    public byte[] getBytes() {
        int extensionLength = 2 + this.algorithms.size() * 2;
        ByteBuffer buffer = ByteBuffer.allocate(4 + extensionLength);
        buffer.putShort(TlsConstants.ExtensionType.signature_algorithms.value);
        buffer.putShort((short)extensionLength);
        buffer.putShort((short)(this.algorithms.size() * 2));
        for (TlsConstants.SignatureScheme namedGroup : this.algorithms) {
            buffer.putShort(namedGroup.value);
        }
        return buffer.array();
    }

    public List<TlsConstants.SignatureScheme> getSignatureAlgorithms() {
        return this.algorithms;
    }
}

