/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.utils;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MapComparator<K extends Comparable<K>, V extends Comparable<V>>
implements Comparator<Map<K, V>> {
    @Override
    public int compare(Map<K, V> o1, Map<K, V> o2) {
        HashSet<K> allKeys = new HashSet<K>();
        allKeys.addAll(o1.keySet());
        allKeys.addAll(o2.keySet());
        List sortedAllKeys = allKeys.stream().sorted().collect(Collectors.toList());
        for (Comparable key : sortedAllKeys) {
            if (!o1.containsKey(key)) {
                return 1;
            }
            if (!o2.containsKey(key)) {
                return -1;
            }
            int result = ((Comparable)o1.get(key)).compareTo((Comparable)o2.get(key));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

