/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.util.AntPathMatcher;
import tech.kronicle.utils.AntStyleIgnoreFileLoader;

public class FileUtils {
    private static final int DEFAULT_MAX_DEPTH = Integer.MAX_VALUE;
    private static final BiPredicate<Path, BasicFileAttributes> ALWAYS_TRUE_MATCHER = (ignored1, ignored2) -> true;
    private static final String GIT_DIR_NAME = ".git";
    private static final String KRONICLEIGNORE_FILE_NAME = ".kronicleignore";
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private final AntStyleIgnoreFileLoader antStyleIgnoreFileLoader;

    public String readFileContent(Path file) {
        try {
            return Files.readString(file, StandardCharsets.UTF_8);
        }
        catch (MalformedInputException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream openFile(Path file) {
        try {
            return Files.newInputStream(file, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeFileContent(Path file, String content, OpenOption ... options) {
        try {
            Files.writeString(file, (CharSequence)content, StandardCharsets.UTF_8, options);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Properties loadProperties(Path file) {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }

    public Stream<Path> findFiles(Path start) {
        return this.findFiles(start, Integer.MAX_VALUE, ALWAYS_TRUE_MATCHER);
    }

    public Stream<Path> findFiles(Path start, int maxDepth) {
        return this.findFiles(start, maxDepth, ALWAYS_TRUE_MATCHER);
    }

    public Stream<Path> findFiles(Path start, BiPredicate<Path, BasicFileAttributes> matcher) {
        return this.findFiles(start, Integer.MAX_VALUE, matcher);
    }

    public Stream<Path> findFiles(Path start, int maxDepth, BiPredicate<Path, BasicFileAttributes> matcher) {
        try {
            return this.cloneAndCloseStream(Files.find(start, maxDepth, this.isRegularFile().and(this.isNotGitFile(start)).and(this.isNotToBeIgnored(start)).and(matcher), new FileVisitOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<FileContent> findFileContents(Path start) {
        return this.findFileContents(start, Integer.MAX_VALUE, ALWAYS_TRUE_MATCHER);
    }

    public Stream<FileContent> findFileContents(Path start, int maxDepth) {
        return this.findFileContents(start, maxDepth, ALWAYS_TRUE_MATCHER);
    }

    public Stream<FileContent> findFileContents(Path start, BiPredicate<Path, BasicFileAttributes> matcher) {
        return this.findFileContents(start, Integer.MAX_VALUE, matcher);
    }

    public boolean fileExists(Path file) {
        return Files.exists(file, new LinkOption[0]);
    }

    public Stream<FileContent> findFileContents(Path start, int maxDepth, BiPredicate<Path, BasicFileAttributes> matcher) {
        return this.findFiles(start, maxDepth, matcher).map(file -> new FileContent((Path)file, this.readFileContent((Path)file))).filter(fileContent -> Objects.nonNull(fileContent.getContent()));
    }

    private <T> Stream<T> cloneAndCloseStream(Stream<T> stream) {
        try (Stream stream2 = stream;){
            Stream stream3 = Stream.of(stream.collect(Collectors.toUnmodifiableList())).flatMap(Collection::stream);
            return stream3;
        }
    }

    private BiPredicate<Path, BasicFileAttributes> isRegularFile() {
        return (ignored, attributes) -> attributes.isRegularFile();
    }

    private BiPredicate<Path, BasicFileAttributes> isNotGitFile(Path start) {
        return (file, attributes) -> this.isNotGitPath(start, (Path)file);
    }

    private boolean isNotGitPath(Path start, Path file) {
        if (file.getFileName().toString().equals(GIT_DIR_NAME)) {
            return false;
        }
        if (file.equals(start)) {
            return true;
        }
        return this.isNotGitPath(start, file.getParent());
    }

    private BiPredicate<Path, BasicFileAttributes> isNotToBeIgnored(Path start) {
        List<String> ignorePatterns = this.getIgnorePatterns(start);
        return (file, attributes) -> {
            String relativeFile = start.relativize((Path)file).toString();
            boolean shouldBeIgnored = ignorePatterns.stream().anyMatch(pattern -> ANT_PATH_MATCHER.matchStart(pattern, relativeFile));
            return !shouldBeIgnored;
        };
    }

    private List<String> getIgnorePatterns(Path start) {
        return Optional.of(start.resolve(KRONICLEIGNORE_FILE_NAME)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(this::readFileContent).map(this.antStyleIgnoreFileLoader::load).orElseGet(List::of);
    }

    @ConstructorProperties(value={"antStyleIgnoreFileLoader"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FileUtils(AntStyleIgnoreFileLoader antStyleIgnoreFileLoader) {
        this.antStyleIgnoreFileLoader = antStyleIgnoreFileLoader;
    }

    public static final class FileContent {
        private final Path file;
        private final String content;

        @ConstructorProperties(value={"file", "content"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FileContent(Path file, String content) {
            this.file = file;
            this.content = content;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Path getFile() {
            return this.file;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getContent() {
            return this.content;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileContent)) {
                return false;
            }
            FileContent other = (FileContent)o;
            Path this$file = this.getFile();
            Path other$file = other.getFile();
            if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
                return false;
            }
            String this$content = this.getContent();
            String other$content = other.getContent();
            return !(this$content == null ? other$content != null : !this$content.equals(other$content));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $file = this.getFile();
            result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
            String $content = this.getContent();
            result = result * 59 + ($content == null ? 43 : $content.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "FileUtils.FileContent(file=" + this.getFile() + ", content=" + this.getContent() + ")";
        }
    }
}

