/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.annotation.JsonAlias;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.Tag;

public final class DiagramConnection
implements ObjectWithReference {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    @JsonAlias(value={"source"})
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String sourceComponentId;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    @JsonAlias(value={"target"})
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String targetComponentId;
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String type;
    private final String label;
    private final String description;
    private final List<@Valid Tag> tags;

    @Override
    public String reference() {
        return this.sourceComponentId + " ==" + (Objects.nonNull(this.type) ? this.type : "") + "==> " + this.targetComponentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DiagramConnectionBuilder builder() {
        return new DiagramConnectionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnectionBuilder toBuilder() {
        return new DiagramConnectionBuilder().sourceComponentId(this.sourceComponentId).targetComponentId(this.targetComponentId).type(this.type).label(this.label).description(this.description).tags(this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getSourceComponentId() {
        return this.sourceComponentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTargetComponentId() {
        return this.targetComponentId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLabel() {
        return this.label;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Tag> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiagramConnection)) {
            return false;
        }
        DiagramConnection other = (DiagramConnection)o;
        String this$sourceComponentId = this.getSourceComponentId();
        String other$sourceComponentId = other.getSourceComponentId();
        if (this$sourceComponentId == null ? other$sourceComponentId != null : !this$sourceComponentId.equals(other$sourceComponentId)) {
            return false;
        }
        String this$targetComponentId = this.getTargetComponentId();
        String other$targetComponentId = other.getTargetComponentId();
        if (this$targetComponentId == null ? other$targetComponentId != null : !this$targetComponentId.equals(other$targetComponentId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sourceComponentId = this.getSourceComponentId();
        result = result * 59 + ($sourceComponentId == null ? 43 : $sourceComponentId.hashCode());
        String $targetComponentId = this.getTargetComponentId();
        result = result * 59 + ($targetComponentId == null ? 43 : $targetComponentId.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DiagramConnection(sourceComponentId=" + this.getSourceComponentId() + ", targetComponentId=" + this.getTargetComponentId() + ", type=" + this.getType() + ", label=" + this.getLabel() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @ConstructorProperties(value={"sourceComponentId", "targetComponentId", "type", "label", "description", "tags"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnection(String sourceComponentId, String targetComponentId, String type, String label, String description, List<@Valid Tag> tags) {
        this.sourceComponentId = sourceComponentId;
        this.targetComponentId = targetComponentId;
        this.type = type;
        this.label = label;
        this.description = description;
        this.tags = tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnection withSourceComponentId(String sourceComponentId) {
        return this.sourceComponentId == sourceComponentId ? this : new DiagramConnection(sourceComponentId, this.targetComponentId, this.type, this.label, this.description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnection withTargetComponentId(String targetComponentId) {
        return this.targetComponentId == targetComponentId ? this : new DiagramConnection(this.sourceComponentId, targetComponentId, this.type, this.label, this.description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnection withType(String type) {
        return this.type == type ? this : new DiagramConnection(this.sourceComponentId, this.targetComponentId, type, this.label, this.description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnection withLabel(String label) {
        return this.label == label ? this : new DiagramConnection(this.sourceComponentId, this.targetComponentId, this.type, label, this.description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnection withDescription(String description) {
        return this.description == description ? this : new DiagramConnection(this.sourceComponentId, this.targetComponentId, this.type, this.label, description, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramConnection withTags(List<@Valid Tag> tags) {
        return this.tags == tags ? this : new DiagramConnection(this.sourceComponentId, this.targetComponentId, this.type, this.label, this.description, tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class DiagramConnectionBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String sourceComponentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String targetComponentId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String label;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Tag> tags;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DiagramConnectionBuilder() {
        }

        @JsonAlias(value={"source"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramConnectionBuilder sourceComponentId(String sourceComponentId) {
            this.sourceComponentId = sourceComponentId;
            return this;
        }

        @JsonAlias(value={"target"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramConnectionBuilder targetComponentId(String targetComponentId) {
            this.targetComponentId = targetComponentId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramConnectionBuilder type(String type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramConnectionBuilder label(String label) {
            this.label = label;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramConnectionBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramConnectionBuilder tags(List<@Valid Tag> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramConnection build() {
            return new DiagramConnection(this.sourceComponentId, this.targetComponentId, this.type, this.label, this.description, this.tags);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DiagramConnection.DiagramConnectionBuilder(sourceComponentId=" + this.sourceComponentId + ", targetComponentId=" + this.targetComponentId + ", type=" + this.type + ", label=" + this.label + ", description=" + this.description + ", tags=" + this.tags + ")";
        }
    }
}

