/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.LogMessageSummary;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=LogLevelSummaryBuilder.class)
public final class LogLevelSummary {
    @Pattern(regexp="[a-zA-Z][a-zA-Z0-9]*(_[a-zA-Z0-9]+)*|[a-zA-Z][a-zA-Z0-9]*(-[a-zA-Z0-9]+)*")
    private final @Pattern(regexp="[a-zA-Z][a-zA-Z0-9]*(_[a-zA-Z0-9]+)*|[a-zA-Z][a-zA-Z0-9]*(-[a-zA-Z0-9]+)*") String level;
    @NotNull
    @Min(value=0L)
    private final @NotNull @Min(value=0L) Long count;
    private final List<LogMessageSummary> topMessages;

    public LogLevelSummary(String level, Long count, List<LogMessageSummary> topMessages) {
        this.level = level;
        this.count = count;
        this.topMessages = ListUtils.createUnmodifiableList(topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static LogLevelSummaryBuilder builder() {
        return new LogLevelSummaryBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelSummaryBuilder toBuilder() {
        return new LogLevelSummaryBuilder().level(this.level).count(this.count).topMessages(this.topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getLevel() {
        return this.level;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Long getCount() {
        return this.count;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<LogMessageSummary> getTopMessages() {
        return this.topMessages;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogLevelSummary)) {
            return false;
        }
        LogLevelSummary other = (LogLevelSummary)o;
        Long this$count = this.getCount();
        Long other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        List<LogMessageSummary> this$topMessages = this.getTopMessages();
        List<LogMessageSummary> other$topMessages = other.getTopMessages();
        return !(this$topMessages == null ? other$topMessages != null : !((Object)this$topMessages).equals(other$topMessages));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        List<LogMessageSummary> $topMessages = this.getTopMessages();
        result = result * 59 + ($topMessages == null ? 43 : ((Object)$topMessages).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "LogLevelSummary(level=" + this.getLevel() + ", count=" + this.getCount() + ", topMessages=" + this.getTopMessages() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelSummary withLevel(String level) {
        return this.level == level ? this : new LogLevelSummary(level, this.count, this.topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelSummary withCount(@NotNull Long count) {
        return this.count == count ? this : new LogLevelSummary(this.level, count, this.topMessages);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LogLevelSummary withTopMessages(List<LogMessageSummary> topMessages) {
        return this.topMessages == topMessages ? this : new LogLevelSummary(this.level, this.count, topMessages);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class LogLevelSummaryBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String level;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Long count;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<LogMessageSummary> topMessages;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        LogLevelSummaryBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelSummaryBuilder level(String level) {
            this.level = level;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelSummaryBuilder count(@NotNull Long count) {
            this.count = count;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelSummaryBuilder topMessages(List<LogMessageSummary> topMessages) {
            this.topMessages = topMessages;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public LogLevelSummary build() {
            return new LogLevelSummary(this.level, this.count, this.topMessages);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "LogLevelSummary.LogLevelSummaryBuilder(level=" + this.level + ", count=" + this.count + ", topMessages=" + this.topMessages + ")";
        }
    }
}

