/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.Tag;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=DocBuilder.class)
public final class Doc {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String id;
    private final String dir;
    private final String file;
    @NotBlank
    private final String name;
    private final String description;
    private final String notes;
    private final List<@Valid Tag> tags;

    public Doc(String id, String dir, String file, String name, String description, String notes, List<@Valid Tag> tags) {
        this.id = id;
        this.dir = dir;
        this.file = file;
        this.name = name;
        this.description = description;
        this.notes = notes;
        this.tags = ListUtils.createUnmodifiableList(tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DocBuilder builder() {
        return new DocBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DocBuilder toBuilder() {
        return new DocBuilder().id(this.id).dir(this.dir).file(this.file).name(this.name).description(this.description).notes(this.notes).tags(this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDir() {
        return this.dir;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getFile() {
        return this.file;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNotes() {
        return this.notes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Tag> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Doc)) {
            return false;
        }
        Doc other = (Doc)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$dir = this.getDir();
        String other$dir = other.getDir();
        if (this$dir == null ? other$dir != null : !this$dir.equals(other$dir)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $dir = this.getDir();
        result = result * 59 + ($dir == null ? 43 : $dir.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Doc(id=" + this.getId() + ", dir=" + this.getDir() + ", file=" + this.getFile() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", notes=" + this.getNotes() + ", tags=" + this.getTags() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Doc withId(String id) {
        return this.id == id ? this : new Doc(id, this.dir, this.file, this.name, this.description, this.notes, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Doc withDir(String dir) {
        return this.dir == dir ? this : new Doc(this.id, dir, this.file, this.name, this.description, this.notes, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Doc withFile(String file) {
        return this.file == file ? this : new Doc(this.id, this.dir, file, this.name, this.description, this.notes, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Doc withName(String name) {
        return this.name == name ? this : new Doc(this.id, this.dir, this.file, name, this.description, this.notes, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Doc withDescription(String description) {
        return this.description == description ? this : new Doc(this.id, this.dir, this.file, this.name, description, this.notes, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Doc withNotes(String notes) {
        return this.notes == notes ? this : new Doc(this.id, this.dir, this.file, this.name, this.description, notes, this.tags);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Doc withTags(List<@Valid Tag> tags) {
        return this.tags == tags ? this : new Doc(this.id, this.dir, this.file, this.name, this.description, this.notes, tags);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class DocBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String dir;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String file;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String notes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Tag> tags;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DocBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocBuilder dir(String dir) {
            this.dir = dir;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocBuilder file(String file) {
            this.file = file;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocBuilder notes(String notes) {
            this.notes = notes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DocBuilder tags(List<@Valid Tag> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Doc build() {
            return new Doc(this.id, this.dir, this.file, this.name, this.description, this.notes, this.tags);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Doc.DocBuilder(id=" + this.id + ", dir=" + this.dir + ", file=" + this.file + ", name=" + this.name + ", description=" + this.description + ", notes=" + this.notes + ", tags=" + this.tags + ")";
        }
    }
}

